package com.gogirl.domain.order.mall;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel("商城收货地址")
@Data
@TableName("mall_customer_address")
public class MallCustomerAddress implements Serializable {

    public static final Integer IS_DEFAULT_TRUE = 1;
    public static final Integer IS_DEFAULT_FALSE = 2;
    @TableId(type = IdType.ID_WORKER)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("收货人id")
    private Integer customerId;

    @ApiModelProperty("收货人姓名")
    private String customerName;

    @ApiModelProperty("是否默认 1-是 2-不是")
    private Integer isDefault;

    @ApiModelProperty("省份")
    private String province;

    @ApiModelProperty("城市")
    private String city;

    @ApiModelProperty("地区")
    private String area;

    private String street;

    @ApiModelProperty("收货物手机号")
    private String phone;

    @ApiModelProperty("详细地址")
    private String address;

    @ApiModelProperty("品牌id")
    private Integer brandId;
}
