package com.gogirl.shared.order;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gogirl.domain.order.serve.OrderManage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * <p>
 * 消费记录返回
 * </p>
 *
 * @author robbendev
 * @since 2020/7/24 1:41 下午
 */
@ApiModel("消费记录返回值")
@Data
public class CustomerOrder {

    @ApiModelProperty("消费总次数")
    private Long orderTimes;

    @ApiModelProperty("消费记录")
    private IPage<OrderManage> pageInfo;

    @ApiModelProperty("总消费金额")
    private BigDecimal sumPay;

    @ApiModelProperty("累计充值次数")
    private Integer totalChargeTimes;

    @ApiModelProperty("累计充值金额")
    private BigDecimal totalChargeAmount
}
