package com.gogirl.infrastructure.config.config;

import com.gogirl.infrastructure.interceptor.AuthHandlerInterceptor;
import com.gogirl.infrastructure.interceptor.LoginHandlerInterceptor;
import com.gogirl.infrastructure.interceptor.SessionHandlerInterceptor;
import lombok.AllArgsConstructor;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

@Configuration
@AllArgsConstructor
public class MvcInterceptorConfig extends WebMvcConfigurationSupport {

    private final LoginHandlerInterceptor loginHandlerInterceptor;
    //    private final LogHandlerInterceptor logHandlerInterceptor;
    private final SessionHandlerInterceptor sessionHandlerInterceptor;
    private final AuthHandlerInterceptor authHandlerInterceptor;

    @Override
    protected void addInterceptors(InterceptorRegistry registry) {

        /*多个拦截器组成一个拦截器链*/
        /*addPathPatterns 用于添加拦截规则*/
        /* **表示拦截所有请求*/
        /*excludePathPatterns 用户排除拦截*/
        registry.addInterceptor(loginHandlerInterceptor)
                .addPathPatterns("/**")
                .excludePathPatterns("/swagger-resources/**", "/webjars/**", "/v2/**", "/swagger-ui.html/**", "/error")
                //登陆
                .excludePathPatterns("/customer/message/pageIn")
                .excludePathPatterns("/customer/message/pageOut")
                .excludePathPatterns("/customer/message/logoutLog")
                .excludePathPatterns("/customer/leisure/queryMinDiscount")
                .excludePathPatterns("/customer/xcx/login")
                .excludePathPatterns("/customer/csrf")
                .excludePathPatterns("/customer/mallCategory/getCategoryTree")
                .excludePathPatterns("/customer/mallCategory/getCategoryList")
                .excludePathPatterns("/customer/mallProduct/queryPageProduct")
                .excludePathPatterns("/customer/mallProduct/queryProduct")
                .excludePathPatterns("/customer/serve/no_queryNewServePage")
                .excludePathPatterns("/customer/serve/queryServeForPage")
                .excludePathPatterns("/customer/broadcast/queryBroadcast")
                .excludePathPatterns("/customer/shop/queryShopEnvironmentPhotos")
                //回调
                .excludePathPatterns("/customer/pay/notifyTimesCard")
                .excludePathPatterns("/customer/pay/notifyCharge")
                .excludePathPatterns("/customer/mallOrderPay/notifyMallOrder")
                .excludePathPatterns("/customer/pay/notifyOrder")
                .excludePathPatterns("/customer/pay/notifyBalanceWxPay")

                .excludePathPatterns("/customer/xcx/authorized1")
                .excludePathPatterns("/customer/xcx/authorizedPhone")
                .excludePathPatterns("/customer/message/queryPageMessage")

                //退款
                .excludePathPatterns("/customer/mallOrderPay/refund/*")
                .excludePathPatterns("/customer/xcx/upload")

                .excludePathPatterns("/technician/xcx/login")
                .excludePathPatterns("/csrf")
                .excludePathPatterns("/technician/xcx/login_t")
                .excludePathPatterns("/technician/phone/bindPhone_t")
                .excludePathPatterns("/technician/phone/getBindCode")
                .excludePathPatterns("/technician/xcx/upload")
                .excludePathPatterns("/technician/xcx/getUserInfo_t")
                .excludePathPatterns("/technician/xcx/choseStore")
                .excludePathPatterns("/technician/xcx/getTechnicianShopList")
        ;

//        registry.addInterceptor(logHandlerInterceptor);
        registry.addInterceptor(sessionHandlerInterceptor);
        registry.addInterceptor(authHandlerInterceptor)
                .addPathPatterns("/**")
                .excludePathPatterns("/swagger-resources/**", "/webjars/**", "/v2/**", "/swagger-ui.html/**", "/error")
                //登陆
                .excludePathPatterns("/customer/message/loginLog")
                .excludePathPatterns("/customer/message/pageIn")
                .excludePathPatterns("/customer/message/pageOut")
                .excludePathPatterns("/customer/message/logoutLog")
                .excludePathPatterns("/customer/leisure/queryMinDiscount")
                .excludePathPatterns("/customer/xcx/login")
                .excludePathPatterns("/customer/csrf")
                .excludePathPatterns("/customer/mallCategory/getCategoryTree")
                .excludePathPatterns("/customer/mallCategory/getCategoryList")
                .excludePathPatterns("/customer/mallProduct/queryPageProduct")
                .excludePathPatterns("/customer/mallProduct/queryProduct")
                .excludePathPatterns("/customer/serve/no_queryNewServePage")
                .excludePathPatterns("/customer/serve/queryServeForPage")
                .excludePathPatterns("/customer/broadcast/queryBroadcast")
                .excludePathPatterns("/customer/shop/queryShopEnvironmentPhotos")
                //回调
                .excludePathPatterns("/customer/pay/notifyTimesCard")
                .excludePathPatterns("/customer/pay/notifyCharge")
                .excludePathPatterns("/customer/mallOrderPay/notifyMallOrder")
                .excludePathPatterns("/customer/pay/notifyOrder")
                .excludePathPatterns("/customer/pay/notifyBalanceWxPay")

                .excludePathPatterns("/customer/xcx/authorized1")
                .excludePathPatterns("/customer/xcx/authorizedPhone")
                .excludePathPatterns("/customer/message/queryPageMessage")

                //退款
                .excludePathPatterns("/customer/mallOrderPay/refund/*")
                .excludePathPatterns("/customer/xcx/upload")

                .excludePathPatterns("/technician/xcx/login")
                .excludePathPatterns("/csrf")
                .excludePathPatterns("/technician/xcx/login_t")
                .excludePathPatterns("/technician/phone/bindPhone_t")
                .excludePathPatterns("/technician/phone/getBindCode")
                .excludePathPatterns("/technician/xcx/upload")
                .excludePathPatterns("/technician/xcx/getUserInfo_t")
                .excludePathPatterns("/technician/xcx/choseStore")
                .excludePathPatterns("/technician/xcx/getTechnicianShopList")
                .excludePathPatterns("/customer/produce/queryProduceDetail")
                .excludePathPatterns("/customer/shop/queryShopForPage")
                .excludePathPatterns("/customer/mallCart/listMallShoppingCart")
                .excludePathPatterns("/customer/queryPageLeisureScheduleServe")
                .excludePathPatterns("/customer/getMyCoupon")
                .excludePathPatterns("/customer/timescard/getMyTimesCardList")
                .excludePathPatterns("/customer/selectAllDiscount")
                .excludePathPatterns("/customer/xcx/getUserInfo")
        ;

        super.addInterceptors(registry);
    }


    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {

        //swagger增加url映射
        registry.addResourceHandler("/swagger-ui.html")
                .addResourceLocations("classpath:/META-INF/resources/");

        registry.addResourceHandler("/webjars/**")
                .addResourceLocations("classpath:/META-INF/resources/webjars/");
    }

//    @Bean
//    public ObjectMapper jacksonObjectMapperCustomization() {
//        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//        TimeZone timeZone = TimeZone.getTimeZone("Asia/Shanghai");
//        format.setTimeZone(timeZone);
//
//        Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder()
//                .timeZone(timeZone)
//                .dateFormat(format);
//
//        return builder.build();
//    }
//
//    @Override
//    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
//        converters.removeIf(c -> c instanceof MappingJackson2HttpMessageConverter);
//        converters.add(new MappingJackson2HttpMessageConverter(jacksonObjectMapperCustomization()));
//    }

}


