package com.gogirl.domain.store.career;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

@TableName("career")
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class Career {

    @TableId(type = IdType.AUTO)
    private Integer id;

    private Integer technicianId;

    private String technicianName;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("加入gogirl时间")
    private Date joinDate;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("在职时间")
    private Integer onJobTime;

    @ApiModelProperty("当月服务客户总数")
    private Integer monthServeCustomerNum;

    @ApiModelProperty("当月服务总次数")
    private Integer monthServeNum;

    @ApiModelProperty("当月订单总数")
    private Integer monthOrderNum;

    @ApiModelProperty("当月开卡总数")
    private Integer monthBalanceCardNum;

    @ApiModelProperty("服务客户总数")
    private Integer totalServeCustomerNum;

    @ApiModelProperty("服务总次数")
    private Integer totalServeNum;

    @ApiModelProperty("订单总数")
    private Integer totalOrderNum;

    @ApiModelProperty("开卡总数")
    private Integer totalBalanceCardNum;

    @ApiModelProperty("客户好评率")
    private BigDecimal monthPraisePercent;

    @ApiModelProperty("复购率")
    private BigDecimal monthRepurchasePercent;

    @ApiModelProperty("信息录入完整度")
    private BigDecimal monthInfoPercent;

    @ApiModelProperty("考勤准时率")
    private BigDecimal monthAttendancePercent;

    @ApiModelProperty("客户好评率")
    private BigDecimal totalPraisePercent;

    @ApiModelProperty("复购率")
    private BigDecimal totalRepurchasePercent;

    @ApiModelProperty("信息录入完整度")
    private BigDecimal totalInfoPercent;

    @ApiModelProperty("考勤准时率")
    private BigDecimal totalAttendancePercent;


    @ApiModelProperty("美甲师评分")
    private Integer techScore;
}
