package com.gogirl.domain.product.mall;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

@ApiModel("小程序商城分类")
@TableName("mall_category")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MallCategory implements Serializable {

    @TableId(type = IdType.ID_WORKER)
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("分类id")
    private Long id;

    @ApiModelProperty("父分类id")
    private Long parentId;

    @ApiModelProperty("分类名称")
    private String categoryName;

    private String picturePath;

    @TableField(exist = false)
    @ApiModelProperty("子节点")
    private List<MallCategory> childList;

    @TableField(exist = false)
    private Integer count;

}
