package com.gogirl.application.xcx.impl;

import com.gogirl.application.xcx.VisitLogService;
import com.gogirl.domain.xcx.VisitsLog;
import com.gogirl.infrastructure.mapper.xcx.VisitsLogMapper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Date;

@Slf4j
@Service
@AllArgsConstructor
public class VisitLogServiceImpl implements VisitLogService {
    private final VisitsLogMapper visitsLogMapper;

    @Override
    public VisitsLog loginLog(Integer customerId) {

        VisitsLog visitsLog = new VisitsLog();

        visitsLog.setCustomerId(customerId);
        //时间
        visitsLog.setTime(new Date());
        //时长
        visitsLog.setDuration(0);
        //来源 打开首页
        visitsLog.setType(1);
        visitsLogMapper.insert(visitsLog);

        return visitsLog;
    }

    @Async
    @Override
    public void logoutLog(Integer visitsId) {
        VisitsLog visitsLog = visitsLogMapper.selectById(visitsId);
        if (visitsLog != null) {
            long duration = new Date().getTime() - visitsLog.getTime().getTime();
            visitsLog.setDuration(Integer.valueOf(String.valueOf(duration / 1000)));
            visitsLogMapper.updateById(visitsLog);
        } else {
            log.error("找不到登入记录 visitId:{}", visitsId);
        }
    }

    @Async
    @Override
    public void recordActivityId(Integer visitsId, Integer activityId) {
        VisitsLog visitsLog = visitsLogMapper.selectById(visitsId);
        if (visitsLog != null) {
            visitsLog.setType(2);
            visitsLog.setActivityId(activityId);
            visitsLogMapper.updateById(visitsLog);
        } else {
            log.error("找不到登入记录 visitId:{}", visitsId);
        }
    }

    @Override
    public VisitsLog pageIn(Integer customerId,
                            Integer type,
                            Integer activityId,
                            Integer shareType,
                            Integer shareUserId,
                            Integer serviceId,
                            Integer departmentId,
                            String pageName, Integer produceId) {

        VisitsLog visitsLog = new VisitsLog();
        visitsLog.setCustomerId(customerId);
        visitsLog.setTime(new Date());
        visitsLog.setDuration(0);

        visitsLog.setActivityId(activityId);
        visitsLog.setShareType(shareType);
        visitsLog.setShareUserId(shareUserId);
        visitsLog.setServiceId(serviceId);
        visitsLog.setPageName(pageName);
        visitsLog.setProduceId(produceId);

        //type有传的话,就直接记录:1.打开首页;4客服推送;
        if (type != null) {
            visitsLog.setType(type);
        }
        //有活动id记录为活动扫码进入
        else if (activityId != null) {
            visitsLog.setType(2);
        }
        //有店铺id,记录为门店扫码进入
        else if (departmentId != null) {
            visitsLog.setShareType(3);
        }
        //有分享者的就记录为分享进入
        else if (shareUserId != null) {
            visitsLog.setShareType(5);
        }
        //啥也没有的,记录为访问内页
        else {
            visitsLog.setType(6);
        }
        visitsLogMapper.insert(visitsLog);
        return visitsLog;
    }

    @Async
    @Override
    public void pageOut(Integer visitsId) {

        VisitsLog visitsLog = visitsLogMapper.selectById(visitsId);
        if (visitsLog != null) {
            long duration = new Date().getTime() - visitsLog.getTime().getTime();
            visitsLog.setDuration(Integer.valueOf(String.valueOf(duration / 1000)));
            visitsLogMapper.updateById(visitsLog);
        } else {
            log.error("登出记录失败 visitId:{}", visitsId);
        }
    }

}
