package com.gogirl.interfaces.product.mall;

import com.gogirl.application.product.mall.MallCategoryService;
import com.gogirl.domain.product.mall.MallCategory;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.CloneUtil;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.util.TreeUtils;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


@Api(tags = "商城商品分类接口")
@RestController
@AllArgsConstructor
public class MallCategoryController {

    private final MallCategoryService mallCategoryService;

    @ApiOperation("获取分类")
    @GetMapping("/customer/mallCategory/getCategoryTree")
    public JsonResult<List<MallCategory>> getCategoryTree() {
        List<MallCategory> list = mallCategoryService.getCategoryTreeList();
        List<MallCategory> data = TreeUtils.listToTree(list);

        return JsonResult.success(data);
    }

    @ApiOperation("根据父节点分类id获取子分类列表")
    @GetMapping("/customer/mallCategory/getCategoryList/{categoryId}")
    public JsonResult<List<MallCategory>> getCategoryList(@PathVariable Long categoryId) {

        List<MallCategory> list = this.getCategoryTree().getData();
        List<MallCategory> result = Lists.newArrayList();
        this.recSubTree(list, categoryId, result);
        return JsonResult.success(result);
    }

    public void recSubTree(List<MallCategory> list, Long subTreeId, List<MallCategory> result) {

        for (MallCategory mallCategory : list) {
            if (mallCategory.getId().equals(subTreeId)) {
                List<MallCategory> clone = CloneUtil.deepClone(mallCategory.getChildList());
                if (ListUtil.isNotEmpty(clone)) {
                    result.addAll(clone);
                }
            } else if (ListUtil.isNotEmpty(mallCategory.getChildList())) {
                this.recSubTree(mallCategory.getChildList(), subTreeId, result);
            }
        }
    }
}
