package com.gogirl.interfaces.common;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.application.common.xcx.CustomerMessageService;
import com.gogirl.application.common.xcx.MessageService;
import com.gogirl.domain.store.store.Message;
import com.gogirl.domain.user.customer.CustomerMessage;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.shared.user.CustomerMessagePageQuery;
import com.gogirl.shared.user.ReadMessageCommand;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@AllArgsConstructor
@Api(tags = {"消息接口"})
@Slf4j
public class MessageController {

    private final CustomerMessageService customerMessageService;
    private final MessageService messageService;


    /*cmd接口开始*/
    @ApiModelProperty("已读消息")
    @PostMapping("/customer/message/customer/readMessage")
    public JsonResult<Void> readMessage(@RequestBody ReadMessageCommand cmd) {
        customerMessageService.readMessage(cmd);
        return JsonResult.success();
    }


    /*query接口开始*/
    @ApiModelProperty("我的消息")
    @PostMapping("/customer/message/queryPageMessage")
    public JsonResult<Page<CustomerMessage>> queryPageMessage(@RequestHeader String token,
                                                              @RequestBody CustomerMessagePageQuery qry) {
        Page<CustomerMessage> customerMessagePage = customerMessageService.queryPageMessage(qry);
        return JsonResult.success(customerMessagePage);
    }


    @ApiOperation(value = "获取我的消息")
    @PostMapping(value = "/technician/message/selectMyMessage")
    public JsonResult<Page<Message>> selectMyMessage(@RequestHeader String token,
                                                     Integer pageSize,
                                                     Integer pageNum,
                                                     Integer type,
                                                     Integer tab) {
        Page<Message> page = messageService.selectMyMessage(pageNum, pageSize, type, tab);
        return JsonResult.success(page);
    }


    @ApiOperation(value = "我的消息管理")
    @PostMapping(value = "/technician/message/myMessageManage")
    public JsonResult<List<Message>> myMessageManage(@RequestHeader String token,
                                                     Integer tab) {
        List<Message> list = messageService.myMessageManage(tab);
        return JsonResult.success(list);
    }


    @ApiOperation(value = "阅读消息")
    @GetMapping(value = "/technician/message/readMessage")
    public JsonResult<Void> readMessage(@RequestParam Integer id) {
        messageService.readMessage(id);
        return JsonResult.success();
    }


}
