package com.gogirl.infrastructure.mapper.market.discount;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.gogirl.domain.market.discount.LeisureDiscountConfigLimit;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDate;
import java.time.LocalTime;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-07-06
 */
public interface LeisureDiscountConfigLimitMapper extends BaseMapper<LeisureDiscountConfigLimit> {

    void syncWeekConfigLimit();

    /**
     * 查询折扣具体天数字的配置
     *  @param date
     * @param leisureDiscountConfigId
     * @return
     */
    LeisureDiscountConfigLimit selectConfigLimit(String date, Integer leisureDiscountConfigId);


    LeisureDiscountConfigLimit selectOneLeisureDiscountConfig(@Param("leisureDiscountConfigId") Integer leisureDiscountConfigId,
                                                            @Param("serveId") Integer serveId,
                                                            @Param("time") LocalTime time,
                                                            @Param("date") LocalDate date);

}
