package com.gogirl.infrastructure.config.config;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.domain.common.dict.Dict;
import com.gogirl.infrastructure.mapper.common.dict.DictMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/4/28 2:36 下午
 */
@Configuration
@Slf4j
public class DictConfig {

    @Resource
    DictMapper dictMapper;
    @Resource
    StringRedisTemplate stringRedisTemplate;

    @PostConstruct
    public void init() {
        log.info("加载字典到redis...");
        List<Dict> dictList = dictMapper.selectList(new LambdaQueryWrapper<>());
        //分组
        Map<String, List<Dict>> dictMap = dictList.stream().collect(Collectors.groupingBy(Dict::getDictCode));
        //字典写入redis
        dictMap.forEach((key, value) ->
                value.forEach(dict -> stringRedisTemplate.opsForHash().put(key, dict.getDictKey(), dict.getDictValue())));
    }
}
