package com.gogirl.domain.order.serve;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.domain.product.serve.BaseServe;
import com.gogirl.domain.store.store.StoreTechnician;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by yinyong on 2018/10/7.
 */

@ApiModel("预约和服务关联")
@TableName("scheduled_serve")
@Data
public class ScheduleServe implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

//    public static final String OWN_PRODUCE_KEY = "自带款";

    @TableId(type = IdType.AUTO)
    @ApiModelProperty("id")
    private Integer id;

    @ApiModelProperty("预约id")
    private Integer schId;

    @ApiModelProperty("预约美甲师id")
    private Integer technicianId;

    private String technicianIds;

    @ApiModelProperty("预约美甲师姓名")
    private String technicianName;

    private String technicianNames;

    @ApiModelProperty("预约服务id")
    private Integer serveId;

    @ApiModelProperty("主服务id")
    private Integer mainServeId;

    @ApiModelProperty("0系统分配美甲师.1.客户指定美甲师")
    private Boolean isCustomerPick;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("开始时间")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("结束时间")
    private Date endTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("创建用户")
    private String createUser;


    @ApiModelProperty("服务时间 分钟")
    private Integer lengthTime;


    /**
     * 款式
     */

    @TableField(strategy = FieldStrategy.IGNORED)
    private BigDecimal discountRate;


    @ApiModelProperty("样式名称")
    @TableField(strategy = FieldStrategy.IGNORED)
    private String produceName;

    @ApiModelProperty("服务数量")
    private Integer serveNumber;

    @TableField(strategy = FieldStrategy.IGNORED)
    @ApiModelProperty("预约款式id")
    private Integer produceId;

    @ApiModelProperty("款式当前价格")
    @TableField(strategy = FieldStrategy.IGNORED)
    private BigDecimal produceCurrentPrice;

    @ApiModelProperty("款式特价")
    @TableField(strategy = FieldStrategy.IGNORED)
    private BigDecimal produceBargainPrice;

    @ApiModelProperty("款式图片地址")
    @TableField(strategy = FieldStrategy.IGNORED)
    private String producePicturePath;
    /**
     * 服务
     */
    @ApiModelProperty("服务名称")
    private String serveName;

    @ApiModelProperty("图片名称")
    private String servePicturePath;

    @ApiModelProperty("服务价格")
    private BigDecimal servePrice = BigDecimal.ZERO;

    @ApiModelProperty("服务分类")
    private String serveType;

    @ApiModelProperty("服务价格")
    private BigDecimal price = BigDecimal.ZERO;

    @ApiModelProperty("服务状态 1-已预约 2-服务中 3-已完成")
    private Integer status = 1;

    @TableField(value = "`explain`")
    @ApiModelProperty("售后说明")
    private String explain;

    @TableField(strategy = FieldStrategy.IGNORED)
    private Integer leisureDiscountConfigId;


    /**
     * 非数据库字段
     */
    @TableField(exist = false)
    @ApiModelProperty("款式对象实体")
    private BaseProduce produce;

    @TableField(exist = false)
    @ApiModelProperty("用于根据前端传过来开始时间计算结束时间")
    private Integer lengthTimeForEndTime;

    @TableField(exist = false)
    @ApiModelProperty("服务实体")
    private BaseServe serve;

    @TableField(exist = false)
    @ApiModelProperty("美甲师实体")
    private StoreTechnician technicianManage;

    @TableField(exist = false)
    @ApiModelProperty("id")
    private Map<Integer, StoreTechnician> mapTechnicianManage;

    @ApiModelProperty("记录类型 0#修改 1#增加 2#删除 3#原始数据  修改时传递数据是增加还是修改")
    @TableField(exist = false)
    private Integer recordType = 0;

    @TableField(exist = false)
    @ApiModelProperty("是否需要卸甲卸睫毛")
    private Boolean needRemoveOldServe;

    @TableField(exist = false)
    @ApiModelProperty("")
    private List<LinkedHashMap> listTechnician;

    @ApiModelProperty("实际开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date actualStartTime;

    @ApiModelProperty("实际结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date actualEndTime;

    @TableField(exist = false)
    private Integer actualServeDuration;

    private BigDecimal promotionPrice;

    private Integer producePromotionTimeId;

    @TableField(strategy = FieldStrategy.IGNORED)
    private BigDecimal leisurePrice;

    @ApiModelProperty("是否自带款式 1-是 2-否")
    private Integer isOwnProduce;

    @ApiModelProperty("自带款式id")
    @TableField(strategy = FieldStrategy.IGNORED)
    private Integer ownProduceId;

    @TableField(exist = false)
    private OwnProduce ownProduce;


    public void calcPriceAndTimeLength() {
        //自带款式
        if (ownProduce != null) {
            price = ownProduce.getPrice();
            lengthTime = ownProduce.getDuration();

        }
        //预约款式
        else if (produceId != null) {
            if (discountRate == null) {
                //没有活动价格
                if (promotionPrice == null) {
                    price = produceCurrentPrice;
                }
                //有活动价
                else {
                    price = produceCurrentPrice.min(promotionPrice);
                }
            } else {
                leisurePrice = produceBargainPrice.multiply(discountRate);
                //没有活动价格
                if (promotionPrice == null) {
                    price = leisurePrice.min(produceCurrentPrice);
                }
                //有活动价
                else {
                    price = leisurePrice.min(produceCurrentPrice).min(promotionPrice);
                }
            }
        }
        //预约服务
        else {
            if (discountRate == null) {
                price = servePrice;
            } else {
                leisurePrice = servePrice.multiply(discountRate);
                price = leisurePrice;
            }
        }

    }

    public Boolean isActivity() {
        return price.equals(leisurePrice) ||
                price.equals(promotionPrice) ||
                (price.equals(produceCurrentPrice) && produceCurrentPrice.compareTo(produceBargainPrice) < 0);
    }

    public Integer getOwnProduceId() {
        return ownProduceId;
    }

    public void setOwnProduceId(Integer ownProduceId) {
        this.ownProduceId = ownProduceId;
    }

    public OwnProduce getOwnProduce() {
        return ownProduce;
    }

    public void setOwnProduce(OwnProduce ownProduce) {
        this.ownProduce = ownProduce;
    }
}
