package com.gogirl.domain.store.store;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.sql.Time;

/**
 * Created by yinyong on 2018/9/20.
 */

@ApiModel("每一家店铺的早晚班时间")

@Data
@TableName("store_classes")
public class StoreClasses implements Serializable {

    @TableId
    private Integer id;

    @ApiModelProperty("班次名称")
    private String name;

    @ApiModelProperty("开始时间")
    @JsonFormat(pattern = "HH:mm:ss", timezone = "GMT+8")
    private Time startTime;

    @ApiModelProperty("结束时间")
    @JsonFormat(pattern = "HH:mm:ss", timezone = "GMT+8")
    private Time endTime;

    @ApiModelProperty("使用人数")
    private Integer useNumber;

    @ApiModelProperty("店铺id")
    private Integer departmentId;


}
