package com.gogirl.application.store.store;

import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.store.store.StoreTechnician;

import java.util.Date;
import java.util.List;

public interface StoreTechnicianService extends IService<StoreTechnician> {

    StoreTechnician getTechnicianManageForDetail(Integer id);

    List<StoreTechnician> listTechnicianForPage(StoreTechnician technicianManage);

    List<StoreTechnician> getTechnicianManageByOpenid(String openid);

    void updateTechnicianByAuthorityId(StoreTechnician item);

    List<StoreTechnician> queryDayTechnicianClasses(Integer departmentId, Date day);

    /**
     * 美甲师登陆
     *
     * @param code
     */
    String login(String code);

    /**
     * 获取美甲师信息（不同店铺对应不同的美甲师）
     * @param token
     * @return
     */
    List<StoreTechnician> getTechnicianInfo(String token);

    StoreTechnician choseStoreByOrderId(String token, Integer orderId);
}
