package com.gogirl.interfaces.dashboard;

import com.gogirl.application.dashboard.DashboardService;
import com.gogirl.application.store.store.StoreManageService;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.feign.AdminFeign;
import com.gogirl.shared.admin.AdminPage;
import com.gogirl.shared.admin.dashboard.req.*;
import com.gogirl.shared.admin.dashboard.resp.GetStoreTrendApiResp;
import com.gogirl.shared.admin.techcnian.AchievementsPersonaResult;
import com.gogirl.shared.admin.techcnian.AchievementsPersonaResultPageApiRequest;
import com.gogirl.shared.admin.techcnian.AdminTechnicianScoreResp;
import com.gogirl.shared.admin.techcnian.GetTechnicianPageRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/8/17 9:09 上午
 */
@Api(tags = "4.0报表")
@RestController
@RequestMapping("/technician/dashboard")
public class DashboardController {
    @Resource
    AdminFeign adminFeign;
    @Resource
    DashboardService dashboardService;
    @Resource
    StoreManageService storeManageService;

    @ApiOperation("见doc文档getStoreTrendApi")
    @PostMapping("/no_getStoreTrendApi")
    public JsonResult<GetStoreTrendApiResp> getStoreTrendApi(@RequestBody GetStoreTrendApiRequest request) {


        GetStoreTrendApiResp resp = dashboardService.getStoreTrendApi(request);
        throw new RRException("Saas服务改造升级 预计22号升级完成");
//        return JsonResult.success(resp);
    }

    @ApiOperation("见doc文档getStoreListApi")
    @PostMapping("/no_getStoreListApi")
    public JsonResult<List<Map<String, Object>>> getStoreListApi(@RequestBody GetStoreListApiRequest request) {
        List<Map<String, Object>> result = dashboardService.getStoreListApi(request);
//        return JsonResult.success(result);
        throw new RRException("Saas服务改造升级 预计22号升级完成");


    }

    @ApiOperation("见doc文档preStorageSumApi")
    @PostMapping("/no_preStorageSumApi")
    public JsonResult<Map<String, Object>> preStorageSumApi(@RequestBody PreStorageSumApiRequest request) {
        Map<String, Object> result = dashboardService.preStorageSumApi(request);
        throw new RRException("Saas服务改造升级 预计22号升级完成");

    }


    @ApiOperation("见doc文档revenueSumByTypeApi")
    @PostMapping(value = "/api/Report/no_revenueSumByTypeApi")
    public JsonResult<Map<String, Object>> revenueSumByTypeApi(@RequestBody RevenueSumByTypeApiRequest request) {
        Map<String, Object> result = dashboardService.revenueSumByTypeApi(request);
        throw new RRException("Saas服务改造升级 预计22号升级完成");

    }


    @ApiOperation("见doc文档revenueTypeListApi")
    @PostMapping("/no_revenueTypeListApi")
    public JsonResult<List<Map<String, Object>>> revenueTypeListApi(@RequestBody RevenueTypeListRequest request) {
        List<Map<String, Object>> result = dashboardService.revenueTypeListApi(request);
        throw new RRException("Saas服务改造升级 预计22号升级完成");


    }


    @ApiOperation("见doc文档revenueSumApi")
    @PostMapping("/no_revenueSumApi")
    public JsonResult<List<Map<String, Object>>> revenueSumApi(@RequestBody RevenueSumApiRequest request) {
        List<Map<String, Object>> result = dashboardService.revenueSumApi(request);
        throw new RRException("Saas服务改造升级 预计22号升级完成");


    }


    @ApiOperation("美甲师信息")
    @PostMapping("/no_getTechnicianPage")
    public JsonResult<AdminPage<AdminTechnicianScoreResp>> getTechnicianPage(@RequestBody GetTechnicianPageRequest request) {
        AdminPage<AdminTechnicianScoreResp> respAdminPage = dashboardService.getTechnicianPage(request);
        throw new RRException("Saas服务改造升级 预计22号升级完成");


    }


    @ApiOperation("美甲师业绩")
    @PostMapping("/no_achievementsPersonaResultPageApi")
    public JsonResult<AdminPage<AchievementsPersonaResult>> achievementsPersonaResultPageApi(@RequestBody AchievementsPersonaResultPageApiRequest request) {
        AdminPage<AchievementsPersonaResult> page = dashboardService.achievementsPersonaResultPageApi(request);
        throw new RRException("Saas服务改造升级 预计22号升级完成");


    }


    @ApiOperation("1级/2级/3级 sku")
    @PostMapping("/no_revenueServiceListApi")
    public JsonResult<List<Map<String, Object>>> revenueServiceListApi(@RequestBody RevenueServiceListApiRequest request) {
        List<Map<String, Object>> result = dashboardService.revenueServiceListApi(request);
        throw new RRException("Saas服务改造升级 预计22号升级完成");


    }
}
