package com.gogirl.interfaces.store.training;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gogirl.application.store.training.ITrainingStartClassLogTechnicianService;
import com.gogirl.domain.store.training.TrainingStartClass;
import com.gogirl.domain.store.training.TrainingStartClassLogTechnician;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.shared.store.SignUpTrainingCommand;
import com.gogirl.shared.store.TrainingStartClassQuery;
import com.gogirl.shared.store.training.QueryPageStartClassLogRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <p>
 * 每次开课，参与的美甲师 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-07-07
 */
@Api(tags = "美甲师培训接口")
@RestController
public class TrainingStartClassLogTechnicianController {
    @Resource
    ITrainingStartClassLogTechnicianService trainingStartClassLogTechnicianService;


    @ApiOperation("培训记录")
    @GetMapping("/technician/career/queryPageStartClassLog")
    public JsonResult<IPage<TrainingStartClassLogTechnician>> queryPageStartClassLog(QueryPageStartClassLogRequest request) {

        IPage<TrainingStartClassLogTechnician> page = trainingStartClassLogTechnicianService.queryPageStartClassLog(request);
        return JsonResult.success(page);
    }

    @ApiOperation("报名技能培训")
    @PostMapping("/technician/career/signUpTraining")
    public JsonResult<Void> signUpTraining(@RequestBody SignUpTrainingCommand cmd) {
        trainingStartClassLogTechnicianService.signUpTraining(cmd);
        return JsonResult.success();
    }

    @ApiOperation("课程列表")
    @PostMapping("/technician/career/queryPageClass")
    public JsonResult<IPage<TrainingStartClass>> queryPageClass(@RequestBody TrainingStartClassQuery qry) {
        IPage<TrainingStartClass> page = trainingStartClassLogTechnicianService.queryPageClass(qry);
        return JsonResult.success(page);
    }

}
