package com.gogirl.interfaces.xcx;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.application.xcx.MessageService;
import com.gogirl.domain.xcx.Message;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@Api(tags = {"10.美甲师消息和用户登入登出记录"}, value = "美甲师消息和用户登入登出记录")
@AllArgsConstructor
@Slf4j
public class TechnicianMessageController {

    private final MessageService messageService;

    @ApiOperation(value = "获取我的消息")
    @PostMapping(value = "/technician/message/selectMyMessage")
    public JsonResult<Page<Message>> selectMyMessage(@RequestHeader String token,
                                                     Integer pageSize,
                                                     Integer pageNum,
                                                     Integer type,
                                                     Integer tab) {
        Page<Message> page = messageService.selectMyMessage(pageNum, pageSize, type, tab);
        return JsonResult.success(page);
    }


    @ApiOperation(value = "我的消息管理")
    @PostMapping(value = "/technician/message/myMessageManage")
    public JsonResult<List<Message>> myMessageManage(@RequestHeader String token,
                                                     Integer tab) {
        List<Message> list = messageService.myMessageManage(tab);
        return JsonResult.success(list);
    }


    @ApiOperation(value = "阅读消息")
    @GetMapping(value = "/technician/message/readMessage")
    public JsonResult<Void> readMessage(@RequestParam Integer id) {
        messageService.readMessage(id);
        return JsonResult.success();
    }

}
