package com.gogirl.shared.product;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/5/14 3:15 下午
 */
@Data
public class PurchaseSkuPOI2 implements Serializable {

    @ExcelProperty("sku")
    @ApiModelProperty("sku码")
    @ColumnWidth(20)
    private String sku;

    @ExcelIgnore
    @ApiModelProperty("商品图")
    @ColumnWidth(20)
    private String picturePath;

    @ExcelProperty("名称")
    @ApiModelProperty("商品名字")
    @ColumnWidth(20)
    private String skuName;

    @ColumnWidth(10)
    @ExcelProperty("店铺看到的价格")
    private BigDecimal shopPrice;

    @ColumnWidth(10)
    @ExcelProperty("采购价格")
    private BigDecimal purchasePrice;

    @ExcelProperty("分类")
    @ApiModelProperty("分类名称")
    @ColumnWidth(20)
    private String skuType;

    @ExcelProperty("型号")
    @ColumnWidth(20)
    private String skuModel;

    @ExcelProperty(value = "sku图片")
    @ApiModelProperty("商品图")
    private URL imagesUrl;

    @ExcelProperty(value = "库存数量")
    @ApiModelProperty("库存数量")
    private Integer quantity;


}
