package com.gogirl.infrastructure.common.config.config;

import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import com.gogirl.application.common.xcx.IMiniappBrandConfigService;
import com.gogirl.domain.common.xcx.MiniappBrandConfig;
import com.gogirl.infrastructure.common.exception.RRException;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.validation.constraints.AssertTrue;
import java.util.*;

/**
 * @Author: li.yanlin
 * @Description： 微信支付初始化，支持多商户
 * @Date: Created in  2021-05-05
 * @Modified by:
 */
@Configuration
@Slf4j
@Data
public class WxPayConfig {

    @Resource
    private IMiniappBrandConfigService miniappBrandConfigService;

    public static Map<Integer,MiniappBrandConfig> brandMap;

    @PostConstruct
    public void init(){
        List<MiniappBrandConfig> brandConfigs = miniappBrandConfigService.list();
        brandMap = new HashMap<>();
        if(Optional.ofNullable(brandConfigs).isPresent()){
            brandConfigs.forEach(x -> brandMap.put(x.getBrandId(),x));
        }
    }

    public static WxPayService wxPayService(Integer brandId){
        if(MapUtils.isNotEmpty(brandMap) && brandMap.containsKey(brandId)) {
            MiniappBrandConfig config = brandMap.get(brandId);
            com.github.binarywang.wxpay.config.WxPayConfig payConfig = new com.github.binarywang.wxpay.config.WxPayConfig();
            payConfig.setAppId(StringUtils.trimToNull(config.getCustomerMiniappId()));
            payConfig.setMchId(StringUtils.trimToNull(config.getMchId()));
            payConfig.setMchKey(StringUtils.trimToNull(config.getMchKey()));
            //payConfig.setSubAppId(StringUtils.trimToNull(this.properties.getSubAppId()));
            //payConfig.setSubMchId(StringUtils.trimToNull(this.properties.getSubMchId()));
            //payConfig.setKeyPath(StringUtils.trimToNull(this.properties.getKeyPath()));

            // 可以指定是否使用沙箱环境
            payConfig.setUseSandboxEnv(false);

            WxPayService wxPayService = new WxPayServiceImpl();
            wxPayService.setConfig(payConfig);
            return wxPayService;
        }
        else {
            throw new RRException(500, "品牌不存在");
        }

    }
}
