package com.gogirl.application.common.xcx.impl;

import com.gogirl.infrastructure.common.config.config.WxPayConfig;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;


@Service
@Slf4j
@AllArgsConstructor
public class AccessTokenService {

    /**
     * 获取accessToken
     *
     * @return accessToken
     */
    public AccessToken getAccessToken(Integer brandId) {

        String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + WxPayConfig.brandMap.get(brandId).getCustomerMiniappId() + "&secret=" + WxPayConfig.brandMap.get(brandId).getCustomerMiniappSecret();

        RestTemplate restTemplate = new RestTemplate();

        String response = restTemplate.getForEntity(url, String.class).getBody();

        JSONObject json = JSONObject.fromObject(response);

        System.out.println(json.toString());
        AccessToken token = new AccessToken();

        token.setAccessToken(json.getString("access_token"));
        token.setExpiresIn(new Integer(json.getString("expires_in")));
        return token;
    }

}
