package com.gogirl.interfaces.store;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.application.store.store.TakeLeaveEventCmdService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.store.oa.TakeLeaveEvent;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.util.SessionUtils;
import com.gogirl.shared.store.command.ApplyTakeLeaveCommand;
import com.gogirl.shared.store.command.ApprovalTakeLeaveCommand;
import com.gogirl.shared.store.query.qry.PageApplyQuery;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "version 3.0: 请假接口")
@RestController
@AllArgsConstructor
public class TakeLeaveEventController {
    /**
     * rpc service
     */
    private final TakeLeaveEventCmdService takeLeaveEventCmdService;

    private final GogirlTokenService gogirlTokenService;


    @ApiOperation("/申请请假")
    @PostMapping("/technician/takeLeave/applyTakeLeave")
    public JsonResult<Void> applyTakeLeave(@RequestHeader String token,
                                           @RequestBody ApplyTakeLeaveCommand cmd) {
        cmd.setApplyTechnicianId(SessionUtils.getTechnicianId());
        takeLeaveEventCmdService.applyTakeLeave(cmd);
        return JsonResult.success();
    }

    @ApiOperation("/分页查询请假接口")
    @PostMapping("/technician/takeLeave/queryPageTakeLeave")
    public JsonResult<Page<TakeLeaveEvent>> queryPageTakeLeave(@RequestBody PageApplyQuery qry) {
        Page<TakeLeaveEvent> page = (Page<TakeLeaveEvent>) takeLeaveEventCmdService.queryPageTakeLeave(qry);
        return JsonResult.success(page);
    }

    @ApiOperation("/查询请假详情")
    @PostMapping("/technician/takeLeave/queryTakeLeave/{id}")
    public JsonResult<TakeLeaveEvent> queryTakeLeave(@RequestHeader String token,
                                                     @PathVariable Long id) {
        TakeLeaveEvent takeLeaveEvent = takeLeaveEventCmdService.queryTakeLeave(id);
        return JsonResult.success(takeLeaveEvent);
    }

    @ApiOperation("/查询可以审核人员列表")
    @GetMapping("/technician/takeLeave/queryCheckTechnicianList")
    public JsonResult<List<StoreTechnician>> queryCheckTechnicianList(@RequestHeader String token) {
        GogirlToken gogirlToken=SessionUtils.getTechnicianToken();
        List<StoreTechnician> list = takeLeaveEventCmdService.queryCheckTechnicianList(gogirlToken.getTechnicianId(), gogirlToken.getDepartmentId());
        return JsonResult.success(list);
    }


    @ApiOperation("/审批请假")
    @PostMapping("/technician/takeLeave/approvalTakeLeave")
    public JsonResult<Void> approvalTakeLeave(@RequestHeader String token,
                                              @RequestBody ApprovalTakeLeaveCommand cmd) {
        GogirlToken gogirlToken=SessionUtils.getTechnicianToken();
        cmd.setCurrentTechnicianId(gogirlToken.getTechnicianId());
        takeLeaveEventCmdService.approvalTakeLeave(cmd);
        return JsonResult.success();
    }
}
