package com.gogirl.shared.member.order.command;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@ApiModel("订单评论")
//@Entity
@Data
public class OrderCommentCommand implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("评论id")

    private Integer id;

    @ApiModelProperty("订单id")
    private Integer orderId;

    @ApiModelProperty("服务id")
    private Integer orderServeId;

    @ApiModelProperty("评论用户id")
    private Integer userId;

    @ApiModelProperty("订单服务评价等级")
    private Integer level;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("图片地址")
    private String picturePath;

    @ApiModelProperty("便签贴")
    private String labelSticker;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("完成时间")
    private Date finishTime;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("状态 1-未评价 2-以评价")
    private Integer status;

    @ApiModelProperty("技师id  关联store_technician")
    private Integer technicianId;

    @ApiModelProperty("订单服务评论得分")
    private Integer orderServeCommentScore;

}
