package com.gogirl.assembler;

import com.gogirl.domain.order.mall.MallShoppingCart;
import com.gogirl.domain.product.purchase.PurchaseSku;
import com.gogirl.shared.product.MallShoppingCartDTO;
import com.gogirl.shared.product.PurchaseSkuDTO;
import lombok.AllArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

import java.util.function.Function;

@Component
@AllArgsConstructor
public class MallShoppingCartDTOAssembler implements Function<MallShoppingCart, MallShoppingCartDTO> {

    private final MallProductDTOAssembler mallProductDTOAssembler;

    @Override
    public MallShoppingCartDTO apply(MallShoppingCart mallShoppingCart) {
        MallShoppingCartDTO mallShoppingCartDTO = new MallShoppingCartDTO();
        BeanUtils.copyProperties(mallShoppingCart, mallShoppingCartDTO);
        if (mallShoppingCart.getMallProduct() != null) {
            mallShoppingCartDTO.setMallProductDTO(mallProductDTOAssembler.apply(mallShoppingCart.getMallProduct()));
        }
        return mallShoppingCartDTO;
    }

    @Component
    static class PurchaseSkuDTOAssembler implements Function<PurchaseSku, PurchaseSkuDTO> {

        @Override
        public PurchaseSkuDTO apply(PurchaseSku purchaseSku) {
            PurchaseSkuDTO purchaseSkuDTO = new PurchaseSkuDTO();
            BeanUtils.copyProperties(purchaseSku, purchaseSkuDTO);
            return purchaseSkuDTO;
        }
    }


}
