package com.gogirl.application.store.complaint.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.store.complaint.ComplaintDetailedService;
import com.gogirl.application.store.complaint.ComplaintMainService;
import com.gogirl.application.store.complaint.IComplaintDetailedTechnicianService;
import com.gogirl.domain.order.serve.OrderManage;
import com.gogirl.domain.order.serve.OrderServe;
import com.gogirl.domain.store.complaint.ComplaintDetailed;
import com.gogirl.domain.store.complaint.ComplaintDetailedTechnician;
import com.gogirl.domain.store.complaint.ComplaintMain;
import com.gogirl.domain.store.complaint.ComplaintSkuView;
import com.gogirl.domain.user.investigation.OrderQuestionOption;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.mapper.order.serve.OrderManageMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderServeMapper;
import com.gogirl.infrastructure.mapper.store.complaint.ComplaintMainMapper;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author luobin
 * @since 2019-11-23
 */
@Service
public class ComplaintMainServiceImpl extends ServiceImpl<ComplaintMainMapper, ComplaintMain> implements ComplaintMainService {

    @Resource
    ComplaintDetailedService complaintDetailedService;
    @Resource
    IComplaintDetailedTechnicianService complaintDetailedTechnicianService;
    @Resource
    OrderServeMapper orderServeMapper;
    @Resource
    OrderManageMapper orderManageMapper;

    @Override
    public void saveComplainsByOrderQuestion(List<OrderQuestionOption> list) {

        list = list.stream()
                .filter(orderQuestionOption -> orderQuestionOption.getComplaintSkuId() != null && orderQuestionOption.getComplaintSkuId() > 0)
                .collect(Collectors.toList());

        if (ListUtil.isNotEmpty(list)) {
            ComplaintMain complaintMain = new ComplaintMain();

            OrderQuestionOption orderQuestionOption = list.stream().findAny().orElseThrow(NullPointerException::new);
            OrderManage orderManage = orderManageMapper.selectById(orderQuestionOption.getOrderId());

            complaintMain.setOrderId(orderQuestionOption.getOrderId());
            complaintMain.setCreateDate(LocalDateTime.now());
            complaintMain.setCustomerId(orderQuestionOption.getCustomerId());
            complaintMain.setPicturePath(null);
            complaintMain.setRemarks(null);
            complaintMain.setSource(ComplaintMain.SOURCE_MP);
            complaintMain.setCreateUser(orderQuestionOption.getCustomerId());
            complaintMain.setStoreId(orderManage.getDepartmentId());
            this.save(complaintMain);

            List<ComplaintDetailed> complaintDetailedList = list
                    .stream()
                    .map(orderQuestionOption1 -> {
                        ComplaintDetailed complaintDetailed = new ComplaintDetailed();
                        complaintDetailed.setComplaintSkuType(orderQuestionOption1.getComplaintType());
                        complaintDetailed.setContent(orderQuestionOption1.getRemarks());
                        complaintDetailed.setMainId(complaintMain.getId());
                        complaintDetailed.setCreateDate(LocalDateTime.now());
                        complaintDetailed.setSkuId(orderQuestionOption1.getComplaintSkuId());

                        ComplaintSkuView complaintSkuView = baseMapper.selectComplaintSkuView(complaintDetailed.getSkuId(), complaintDetailed.getComplaintSkuType());
                        return complaintDetailed;
                    })
                    .collect(Collectors.toList());

            complaintDetailedService.saveBatch(complaintDetailedList);

            Set<Integer> orderTechnicianIds = orderServeMapper.selectList(
                    new LambdaQueryWrapper<OrderServe>().eq(OrderServe::getOrderId, complaintMain.getOrderId()))
                    .stream()
                    .map(OrderServe::getTechnicianId)
                    .map(technicianIds -> Lists.newArrayList(technicianIds.split(",")))
                    .flatMap(List::stream)
                    .map(Integer::valueOf)
                    .collect(Collectors.toSet());

            List<ComplaintDetailedTechnician> complaintDetailedTechnicianList = complaintDetailedList
                    .stream()
                    .map(complaintDetailed -> orderTechnicianIds.stream()
                            .map(id -> {
                                ComplaintDetailedTechnician complaintDetailedTechnician = new ComplaintDetailedTechnician();
                                complaintDetailedTechnician.setComplaintDetailedId(complaintDetailed.getId());
                                complaintDetailedTechnician.setTechnicianId(id);
                                return complaintDetailedTechnician;
                            })
                            .collect(Collectors.toList()))
                    .flatMap(List::stream)
                    .collect(Collectors.toList());
            complaintDetailedTechnicianService.saveBatch(complaintDetailedTechnicianList);
        }
    }
}
