package com.gogirl.interfaces.xcx;

import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.gogirl.application.order.market.ITimesCardOrderService;
import com.gogirl.application.order.member.IChargeOrderService;
import com.gogirl.application.order.serve.OrderManageService;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author robbendev
 * @Description //TODO
 * @Date 2019/12/29
 **/
@RestController
@AllArgsConstructor
@Slf4j
public class WxCallbackController {


    private final OrderManageService orderManageService;
    private final IChargeOrderService chargeOrderService;
    private final ITimesCardOrderService timesCardOrderService;

    @ApiOperation(value = "预约订单微信支付回调")
    @PostMapping("/customer/pay/notifyOrder")
    public String notifyWxPayOrder(@RequestBody String xmlData) {
        log.info("支付回调参数xmlData:" + xmlData);
        WxPayOrderNotifyResult result = WxPayOrderNotifyResult.fromXML(xmlData);
        if (result.getReturnCode().equals("SUCCESS") && result.getResultCode().equals("SUCCESS")) {
            orderManageService.notifyWxPayOrder(result);
        }
        return WxPayNotifyResponse.success("成功");
    }

    @ApiOperation(value = "预约订单(微信+余额)支付回调")
    @PostMapping("/customer/pay/notifyBalanceWxPay")
    public String notifyBalanceWxPayOrder(@RequestBody String xmlData) {
        log.info("支付回调参数xmlData:" + xmlData);
        WxPayOrderNotifyResult result = WxPayOrderNotifyResult.fromXML(xmlData);
        if (result.getReturnCode().equals("SUCCESS") && result.getResultCode().equals("SUCCESS")) {
            orderManageService.notifyBalanceWxPayOrder(result);
        }
        return WxPayNotifyResponse.success("成功");
    }

    @ApiOperation(value = "充值订单微信支付回调")
    @RequestMapping("/customer/pay/notifyCharge")
    public String notifyChargeOrder(@RequestBody String xmlData) {
        log.info("支付回调参数xmlData:" + xmlData);
        WxPayOrderNotifyResult result = WxPayOrderNotifyResult.fromXML(xmlData);
        if (result.getReturnCode().equals("SUCCESS") && result.getResultCode().equals("SUCCESS")) {
            chargeOrderService.notifyChargeOrder(result);
        }
        return WxPayNotifyResponse.success("成功");
    }

    @ApiOperation(value = "次卡订单微信支付回调")
    @RequestMapping("/customer/pay/notifyTimesCard")
    public String notifyTimesCardOrder(@RequestBody String xmlData) {
        log.info("支付回调参数xmlData:" + xmlData);
        WxPayOrderNotifyResult result = WxPayOrderNotifyResult.fromXML(xmlData);
        if (result.getReturnCode().equals("SUCCESS") && result.getResultCode().equals("SUCCESS")) {
            timesCardOrderService.notifyTimesCardOrder(result);
        }
        return WxPayNotifyResponse.success("成功");
    }
}
