package com.gogirl.domain.common;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 代理规则
 * </p>
 *
 * @author robbendev
 * @since 2020-11-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="AgentConfig对象", description="代理规则")
public class AgentConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "描述")
    private String title;

    @ApiModelProperty(value = "预充金额")
    private BigDecimal rechargeAmount;

    @ApiModelProperty(value = "保证金")
    private BigDecimal bondAmount;

    @ApiModelProperty(value = "代理门槛")
    private BigDecimal thresholdAmount;

    @ApiModelProperty(value = "代理折扣")
    private BigDecimal discount;

    @ApiModelProperty(value = "福利")
    private String welfare;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createDate;

    @ApiModelProperty(value = "创建人")
    private String createUser;

    @ApiModelProperty(value = "是否作废")
    private Integer isDelete;

    @ApiModelProperty(value = "删除时间")
    private LocalDateTime deleteDate;

    @ApiModelProperty(value = "删除人")
    private String deleteUser;

    @ApiModelProperty(value = "品牌id")
    private Integer brandId;


}
