package com.gogirl.application.store.store;


import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.store.store.StoreClassesTechnician;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.shared.store.UpdateDayTechnicianClassesReq;

import java.text.ParseException;
import java.util.Date;
import java.util.List;


public interface StoreClassesTechnicianService extends IService<StoreClassesTechnician> {



    /**
     * 查询美甲师排班详和美甲师当前正在做的服务
     *
     * @param userId
     * @param days
     * @return
     */
    List<StoreClassesTechnician> listClassesTechnicianDetail(Integer userId, String days);

    /**
     * 店铺端查询美甲师可用时间
     *
     * @param startDate
     * @param startTime
     * @param departmentId
     * @return
     */
    List<StoreClassesTechnician> getReservableTime(String startDate, String startTime, Integer departmentId);

    /**
     * 美甲师查询当天排班
     *
     * @param departmentId
     * @param day
     * @return
     */
    List<StoreTechnician> queryDayTechnicianClasses(Integer departmentId, Date day);

    /**
     * 美甲师提交排班
     *
     * @param updateDayTechnicianClassesReq
     */
    void updateDayTechnicianClasses(UpdateDayTechnicianClassesReq updateDayTechnicianClassesReq) throws ParseException;

}
