package com.gogirl.infrastructure.service.push.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.domain.order.serve.ScheduleManage;
import com.gogirl.domain.order.serve.ScheduleServe;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.dto.EnterpriseWxMsg;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.config.property.GogirlProperties;
import com.gogirl.infrastructure.mapper.order.serve.ScheduleManageMapper;
import com.gogirl.infrastructure.mapper.order.serve.ScheduleServeMapper;
import com.gogirl.infrastructure.mapper.store.store.StoreTechnicianMapper;
import com.gogirl.infrastructure.service.push.TechnicianPushService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.stream.Collectors;

@Service
@Slf4j
public class TechnicianPushServiceImpl implements TechnicianPushService {
    @Resource
    RestTemplate restTemplate;
    @Resource
    ScheduleManageMapper scheduleManageMapper;
    @Resource
    ScheduleServeMapper scheduleServeMapper;
    @Resource
    StoreTechnicianMapper storeTechnicianMapper;
    @Resource
    GogirlProperties gogirlProperties;

    @Override
    public void scheduledMsg(Integer scheduledId) {
        ScheduleManage scheduleManage = scheduleManageMapper.selectById(scheduledId);
        String name = scheduleManage.getStoreScheduleUsername();
        String phone = scheduleManage.getTelephone();
        String date = new SimpleDateFormat("yyyy年MM月dd HH:mm:ss").format(scheduleManage.getArriveTime());

        List<ScheduleServe> scheduleServeList = scheduleServeMapper.selectList(new LambdaQueryWrapper<ScheduleServe>().eq(ScheduleServe::getSchId, scheduledId));
        String serves = scheduleServeList.stream().map(ScheduleServe::getServeName).collect(Collectors.joining(","));
        List<StoreTechnician> storeTechnicianList = storeTechnicianMapper.selectBatchIds(scheduleServeList.stream().map(ScheduleServe::getTechnicianId).collect(Collectors.toList()));
        String technicianNames = storeTechnicianList.stream().map(StoreTechnician::getName).collect(Collectors.joining(","));

        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        EnterpriseWxMsg enterpriseWxMsg = new EnterpriseWxMsg();
        enterpriseWxMsg.setMsgtype("text");

        EnterpriseWxMsg.EnterpriseTextWxMsg textWxMsg = new EnterpriseWxMsg.EnterpriseTextWxMsg();
        StringBuilder builder = new StringBuilder();
        String content = builder.append("预约提醒\n\n")
                .append("预约客户: ").append(name).append("\n")
                .append("预约客户手机: ").append(phone).append("\n")
                .append("预约时: ").append(date).append("\n")
                .append("预约技师: ").append(technicianNames).append("\n")
                .append("预约项目: ").append(serves).append("\n")
                .toString();
        textWxMsg.setMentioned_mobile_list(storeTechnicianList.stream().map(StoreTechnician::getMobile).collect(Collectors.toList()));
        textWxMsg.setContent(content);

        enterpriseWxMsg.setText(textWxMsg);
        HttpEntity<EnterpriseWxMsg> httpEntity = new HttpEntity<>(enterpriseWxMsg, httpHeaders);
        log.info("发送企业微信消息：{}", JsonUtilByFsJson.beanToJson(enterpriseWxMsg));
        String response = restTemplate.exchange(gogirlProperties.getEnterpriseWechatWebhook(), HttpMethod.POST, httpEntity, String.class).getBody();
        log.info("发送企业微信消息响应：{}", response);

    }

    @Override
    public void cancelScheduledMsg(Integer scheduledId) {
        ScheduleManage scheduleManage = scheduleManageMapper.selectById(scheduledId);
        String name = scheduleManage.getStoreScheduleUsername();
        String phone = scheduleManage.getTelephone();
        String date = new SimpleDateFormat("yyyy年MM月dd日 HH:mm:ss").format(scheduleManage.getArriveTime());

        List<ScheduleServe> scheduleServeList = scheduleServeMapper.selectList(new LambdaQueryWrapper<ScheduleServe>().eq(ScheduleServe::getSchId, scheduledId));
        String serves = scheduleServeList.stream().map(ScheduleServe::getServeName).collect(Collectors.joining(","));
        List<StoreTechnician> storeTechnicianList = storeTechnicianMapper.selectBatchIds(scheduleServeList.stream().map(ScheduleServe::getTechnicianId).collect(Collectors.toList()));
        String technicianNames = storeTechnicianList.stream().map(StoreTechnician::getName).collect(Collectors.joining(","));

        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        EnterpriseWxMsg enterpriseWxMsg = new EnterpriseWxMsg();
        enterpriseWxMsg.setMsgtype("text");

        EnterpriseWxMsg.EnterpriseTextWxMsg textWxMsg = new EnterpriseWxMsg.EnterpriseTextWxMsg();
        StringBuilder builder = new StringBuilder();
        String content = builder.append("用户取消预约提醒\n\n")
                .append("预约客户: ").append(name).append("\n")
                .append("预约客户手机: ").append(phone).append("\n")
                .append("预约时间: ").append(date).append("\n")
                .append("预约技师: ").append(technicianNames).append("\n")
                .append("预约项目: ").append(serves).append("\n")
                .append("取消原因: 用户取消")
                .toString();
        textWxMsg.setMentioned_mobile_list(storeTechnicianList.stream().map(StoreTechnician::getMobile).collect(Collectors.toList()));
        textWxMsg.setContent(content);

        enterpriseWxMsg.setText(textWxMsg);
        HttpEntity<EnterpriseWxMsg> httpEntity = new HttpEntity<>(enterpriseWxMsg, httpHeaders);
        log.info("发送企业微信消息参数：{}", JsonUtilByFsJson.beanToJson(enterpriseWxMsg));
        String response = restTemplate.exchange(gogirlProperties.getEnterpriseWechatWebhook(), HttpMethod.POST, httpEntity, String.class).getBody();
        log.info("发送企业微信消息响应：{}", response);
    }

    @Override
    public void ScheduledOverTimeMsg(Integer scheduledId) {
        ScheduleManage scheduleManage = scheduleManageMapper.selectById(scheduledId);
        String name = scheduleManage.getStoreScheduleUsername();
        String phone = scheduleManage.getTelephone();
        String date = new SimpleDateFormat("yyyy年MM月dd日 HH:mm:ss").format(scheduleManage.getArriveTime());

        List<ScheduleServe> scheduleServeList = scheduleServeMapper.selectList(new LambdaQueryWrapper<ScheduleServe>().eq(ScheduleServe::getSchId, scheduledId));
        String serves = scheduleServeList.stream().map(ScheduleServe::getServeName).collect(Collectors.joining(","));
        List<StoreTechnician> storeTechnicianList = storeTechnicianMapper.selectBatchIds(scheduleServeList.stream().map(ScheduleServe::getTechnicianId).collect(Collectors.toList()));
        String technicianNames = storeTechnicianList.stream().map(StoreTechnician::getName).collect(Collectors.joining(","));

        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        EnterpriseWxMsg enterpriseWxMsg = new EnterpriseWxMsg();
        enterpriseWxMsg.setMsgtype("text");

        EnterpriseWxMsg.EnterpriseTextWxMsg textWxMsg = new EnterpriseWxMsg.EnterpriseTextWxMsg();
        StringBuilder builder = new StringBuilder();
        String content = (builder.append("超时取消提醒\n\n")
                .append("预约客户: ").append(name).append("\n")
                .append("预约客户手机: ").append(phone).append("\n")
                .append("预约时间: ").append(date).append("\n")
                .append("预约技师: ").append(technicianNames).append("\n")
                .append("预约项目: ").append(serves).append("\n")
                .append("取消原因: 超时取消"))
                .toString();
        textWxMsg.setMentioned_mobile_list(storeTechnicianList.stream().map(StoreTechnician::getMobile).collect(Collectors.toList()));
        textWxMsg.setContent(content);

        enterpriseWxMsg.setText(textWxMsg);
        HttpEntity<EnterpriseWxMsg> httpEntity = new HttpEntity<>(enterpriseWxMsg, httpHeaders);
        log.info("发送企业微信消息参数：{}", JsonUtilByFsJson.beanToJson(enterpriseWxMsg));
        String response = restTemplate.exchange(gogirlProperties.getEnterpriseWechatWebhook(), HttpMethod.POST, httpEntity, String.class).getBody();
        log.info("发送企业微信消息响应：{}", response);

    }
}
