package com.gogirl.domain.xcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel("小程序登入记录")

@Data
@TableName("visits_log")
public class VisitsLog {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("客户id")
    private Integer customerId;

    private Date time;

    @ApiModelProperty("时长")
    private Integer duration;

    @ApiModelProperty("1 = 打开首页 2 = 活动扫码 3 = 门店扫码 4 = 客服推送小程序 5 = 老带新 6 = 访问内页")
    private Integer type;

    @ApiModelProperty("来源 活动id")
    private Integer activityId;

    @ApiModelProperty("1 = 内部员工分享 2 = 客户分享")
    private Integer shareType;

    @ApiModelProperty("分享用户id share_type = 1 - store_technician share_type = 2 - customer")
    private Integer shareUserId;

    @ApiModelProperty("服务id")
    private Integer serviceId;

    @ApiModelProperty("页面名称")
    private String pageName;

    private Integer produceId;

}
