package com.gogirl.interfaces.customer;


import com.gogirl.application.customer.ICustomerInfoEnumService;
import com.gogirl.domain.customer.CustomerInfoEnum;
import com.gogirl.infrastructure.common.annotation.AuthIgnore;
import com.gogirl.infrastructure.common.annotation.LoginIgnore;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-11-02
 */
@RestController
@RequestMapping("/customer/customerInfoEnum")
public class CustomerInfoEnumController {

    @Resource
    ICustomerInfoEnumService customerInfoEnumService;

    @AuthIgnore
    @LoginIgnore
    @ApiOperation("职业偏好查询")
    @GetMapping("/list")
    public JsonResult<List<CustomerInfoEnum>> list() {
        return JsonResult.success(customerInfoEnumService.list());
    }
}
