package com.gogirl.interfaces.common;


import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.gogirl.application.common.IAgentUserService;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.net.UnknownHostException;

/**
 * <p>
 * 代理用户 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-11-02
 */
@Api(tags = "代理用户接口")
@RestController
@RequestMapping("/customer/agentUser")
public class AgentUserController {

    @Resource
    IAgentUserService agentUserService;

    @ApiOperation("代理余额充值")
    @GetMapping("/chargeAmount")
    public JsonResult<WxPayMpOrderResult> chargeAmount(@RequestParam Integer agentConfigId) throws WxPayException, UnknownHostException {
        WxPayMpOrderResult result = agentUserService.chargeAmount(agentConfigId);
        return JsonResult.success(result);
    }



}
