package com.gogirl.application.common;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.gogirl.domain.common.AgentUser;

import java.math.BigDecimal;
import java.net.UnknownHostException;

/**
 * <p>
 * 代理用户 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-11-02
 */
public interface IAgentUserService extends IService<AgentUser> {

    /**
     * 根据手机号码查询代理商
     *
     * @param phone
     * @return
     */
    AgentUser selectByPhone(String phone);

    /**
     * 代理商充值
     *
     * @param agentConfigId
     * @return
     */
    WxPayMpOrderResult chargeAmount(Integer agentConfigId) throws UnknownHostException, WxPayException;

    /**
     * 代理充值回调用
     *
     * @param result
     */
    void notifyChargeAgent(WxPayOrderNotifyResult result);

    /**
     * 消费代理余额
     *
     * @param type        1 = 充值余额 2 = 商城订单扣余额  3 = 充保证金 4 = 商城订单扣保证金
     * @param amount
     * @param agentUserId
     */
    void addBalanceLog(Integer type, BigDecimal amount, Integer agentUserId);
}
