package com.gogirl.shared.user.query.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class CustomerMessageDTO {

    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("顾客id")
    private Integer customerId;

    @ApiModelProperty("消息标题")
    private String header;

    @ApiModelProperty("消息内容")
    private String body;

    @ApiModelProperty("1-商城订单代收款消息  2-预约订单代收款消息")
    private Integer type;

    @ApiModelProperty("1-未读 2-已读")
    private Integer status;

    private Long createTime;

    @ApiModelProperty("消息携带参数")
    private String paramsJson;


}
