package com.gogirl.infrastructure.util;


import com.gogirl.infrastructure.common.exception.RRException;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;

import java.security.InvalidAlgorithmParameterException;


/**
 * 封装对外访问方法
 *
 * @author liuyazhuang
 */
public class WXCore {
    /**
     * 解密数据
     *
     * @return
     */
    public static JSONObject decrypt(String encryptedData,
                                     String sessionKey,
                                     String iv) throws InvalidAlgorithmParameterException {
        String result;
        AESUtil aes = new AESUtil();
        byte[] resultByte = aes.decrypt(Base64.decodeBase64(encryptedData),
                Base64.decodeBase64(sessionKey), Base64.decodeBase64(iv));
        if (null != resultByte && resultByte.length > 0) {
            result = new String(WxPKCS7Encoder.decode(resultByte));
            return JSONObject.fromObject(result);
        }
        throw new RRException(2000, "token失效，请重新登陆");
    }
}
