package com.gogirl.infrastructure.util;

import com.gogirl.domain.product.mall.MallCategory;

import java.util.ArrayList;
import java.util.List;

/**
 * 树结构工具类
 *
 * @author robbendev
 */
public class TreeUtils {


    /**
     * 商品分类列表转成树形接口
     *
     * @param list 商品分类列表
     * @return 商品分类树🌲
     */
    public static List<MallCategory> listToTree(List<MallCategory> list) {
        //用递归找子。
        List<MallCategory> treeList = new ArrayList<>();
        for (MallCategory tree : list) {
            if (tree.getParentId() == 0) {
                MallCategory child = findChildren(tree, list);
                if (child.getCount() > 0) {
                    treeList.add(child);
                }
            }
        }
        return treeList;
    }


    private static MallCategory findChildren(MallCategory tree, List<MallCategory> list) {
        for (MallCategory node : list) {
            if (node.getParentId().equals(tree.getId())) {
                if (tree.getChildList() == null) {
                    tree.setChildList(new ArrayList<>());
                }
                MallCategory child = findChildren(node, list);
                if (child.getCount() > 0) {
                    int count = tree.getCount() + child.getCount();
                    tree.getChildList().add(child);
                    tree.setCount(count);
                }
            }
        }
        return tree;
    }

}
