package com.gogirl.infrastructure.common.exception;


import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.exception.RRException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Map;

/**
 * 统一异常处理器
 *
 * @author robbendev
 */
@ControllerAdvice
@ResponseBody
@Slf4j
public class RRExceptionHandler {

    /**
     * 自定义异常
     */
    @ExceptionHandler(RRException.class)
    public JsonResult<String> handleRRException(HttpServletRequest request,
                                                RRException e) {
        JsonResult<String> result = new JsonResult<>();
        result.setSuccess(false);
        result.setCode(e.getCode());
        result.setMessage(e.getMessage());

        if (e.getCode() != 2000 && e.getCode() != 1001 && e.getCode() != 2005 && e.getCode() != 2006) {

            log.error("Params    : {}", getParamString(request.getParameterMap()) + "\n");
            log.error("URI       : {}", request.getRequestURI() + "\n");
            log.error(e.getMessage(), e);
        } else {
            log.error("Params    : {}", getParamString(request.getParameterMap()) + "\n");
            log.error("URI       : {}", request.getRequestURI() + "\n");
            log.error(e.getMessage());
        }
        return result;
    }

    /**
     * 通用异常
     */
    @ExceptionHandler(Exception.class)
    public JsonResult<String> handleException(HttpServletRequest request,
                                              Exception e) {
        JsonResult<String> result = new JsonResult<>();
        result.setSuccess(false);
        result.setCode(500);
        result.setMessage(e.getMessage());
        log.error("Params    : {}", getParamString(request.getParameterMap()) + "\n");
        log.error("URI       : {}", request.getRequestURI() + "\n");
        log.error(e.getMessage(), e);
        return result;
    }

    @ExceptionHandler(MethodArgumentNotValidException.class)
    public JsonResult<String> MethodArgumentNotValidException(HttpServletRequest request,
                                                              MethodArgumentNotValidException ex) {

        JsonResult<String> result = new JsonResult<>();
        result.setSuccess(false);
        result.setCode(500);
        result.setMessage("参数错误。");
        log.error("Params    : {}", getParamString(request.getParameterMap()) + "\n");
        log.error("URI       : {}", request.getRequestURI() + "\n");
        log.error(ex.getMessage(), ex);
        return result;
    }

    private String getParamString(Map<String, String[]> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String[]> e : map.entrySet()) {
            sb.append(e.getKey()).append("=");
            String[] value = e.getValue();
            if (value != null && value.length == 1) {
                sb.append(value[0]).append("\t");
            } else {
                sb.append(Arrays.toString(value)).append("\t");
            }
        }
        return sb.toString();
    }
}
