package com.gogirl.domain.user.customer;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@ApiModel("用户详情数据表")
@TableName("customer_detail")
@Data
public class CustomerDetail {

    @TableId(type = IdType.AUTO)
    private Integer id;

    private Integer customerId;

    @ApiModelProperty("微信号")
    private String wechatId;

    @ApiModelProperty("推荐人")
    private String referee;

    @ApiModelProperty("首次服务时间")
    private String firstServeTime;

    @ApiModelProperty("年龄")
    private Integer age;

    @ApiModelProperty("生日")
    private String birthday;

    @ApiModelProperty("是否结婚")
    private String maritalStatus;

    @ApiModelProperty("是否有小孩")
    private String haveChildren;

    @ApiModelProperty("爱好")
    private String hobby;

    @ApiModelProperty("肤色")
    private String colourOfSkin;

    @ApiModelProperty("甲床类型")
    private String typeOfNailBed;

    @ApiModelProperty("喜欢的甲")
    private String nailType;

    @ApiModelProperty("指甲硬度")
    private Integer nailHardness;

    @ApiModelProperty("住址")
    private Integer residence;

    @ApiModelProperty("工作区域")
    private Integer workAddress;

    @ApiModelProperty("职业")
    private Integer occupation;

    @ApiModelProperty("做指甲的频率")
    private Integer frequencyOfNail;

    @ApiModelProperty("重视美甲沙龙的要点")
    private String keyPointsOfSalon;

    @ApiModelProperty("喜欢什么款式")
    private String likeStyle;

    @ApiModelProperty("用户的顾虑")
    private String customerConcerns;

    @ApiModelProperty("解决方案")
    private String solution;

    @ApiModelProperty("睫毛状况")
    private String eyelashCondition;

    @ApiModelProperty("眼型")
    private String eyeShape;

    @ApiModelProperty("问券照片")
    private String questionnaireImgUrl;

    @ApiModelProperty("从哪里了解到gogirl")
    private String learnAboutUs;

    @ApiModelProperty("职业")
    private String job;

    @ApiModelProperty("偏好")
    private String preference;

    @ApiModelProperty("性格")
    @TableField(value = "`character`")
    private String character;

    private Integer birthdayMonth;

    private Integer birthdayDay;

    private String ageGroup;

}
