package com.gogirl.application.market;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.market.coupon.CouponCustomerRelevance;

import java.util.List;

public interface CouponCustomerRelevanceService extends IService<CouponCustomerRelevance> {

    /**
     * 获取订单可用卡券
     *
     * @param currentCustomerId
     * @param orderId
     * @return
     */
    List<CouponCustomerRelevance> getOrderCoupon(Integer currentCustomerId, Integer orderId);

    /**
     * 获取我的优惠券列表
     *
     * @param customerId
     * @param pageNum
     * @param pageSize
     * @param state
     * @param containRemoveCoupon
     * @return
     */
    IPage<CouponCustomerRelevance> selectMyCoupon(Integer customerId, Integer pageNum, Integer pageSize, Integer state, Boolean containRemoveCoupon);

    /**
     * 美甲师提交外部券
     *
     * @param orderId
     * @param idList
     */
    void techSubmitCoupons(Integer orderId, List<Integer> idList);
}
