package com.gogirl.domain.order.mall;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.gogirl.domain.product.purchase.PurchaseSku;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * one to one {@link PurchaseSku}
 */
@ApiModel("用户购物车")
@TableName("mall_shopping_cart")
@Data
public class MallShoppingCart {

    @ApiModelProperty("主键")
    @TableId(type = IdType.ID_WORKER)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "用户id")
    private Integer customerId;

    @ApiModelProperty(value = "加入购物车的产品skuId", required = true)
    private Long productId;

    @ApiModelProperty(value = "产品sku数量", required = true)
    private Integer num;

    private Long createTime;

    private Long lastUpdateTime;

}
