package com.gogirl.application.store.store.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.store.store.StoreClassesService;
import com.gogirl.application.store.store.StoreClassesTechnicianService;
import com.gogirl.domain.store.store.StoreClasses;
import com.gogirl.domain.store.store.StoreClassesTechnician;
import com.gogirl.infrastructure.mapper.store.store.StoreClassesMapper;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@AllArgsConstructor
public class StoreClassesServiceImpl extends ServiceImpl<StoreClassesMapper, StoreClasses> implements StoreClassesService {

    private final StoreClassesTechnicianService storeClassesTechnicianService;

    @Override
    public List<StoreClassesTechnician> queryMonthClasses(Integer technicianId, Integer departmentId, String month) {
        List<StoreClasses> classList = this.list(new LambdaQueryWrapper<StoreClasses>().eq(StoreClasses::getDepartmentId, departmentId));

        Map<Integer, Integer> map = new HashMap<Integer, Integer>();//处理一个对应关系只返回012
        map.put(0, 0);
        for (int i = 0; i < classList.size(); i++) {
            StoreClasses item = classList.get(i);
            if (item.getName().equals("早班")) {
                map.put(item.getId(), 1);
            } else if (item.getName().equals("晚班")) {
                map.put(item.getId(), 2);
            }
        }

        List<StoreClassesTechnician> lists = storeClassesTechnicianService.listClassesTechnicianDetail(technicianId, month);
        //替换排班的class
        for (StoreClassesTechnician item : lists) {
            item.setClasses(map.get(item.getClasses()));
        }
        return lists;
    }
}
