package com.gogirl.interfaces.dashboard;

import com.gogirl.application.dashboard.DashboardService;
import com.gogirl.application.store.store.StoreManageService;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.feign.AdminFeign;
import com.gogirl.shared.admin.AdminPage;
import com.gogirl.shared.admin.dashboard.req.*;
import com.gogirl.shared.admin.dashboard.resp.GetStoreTrendApiResp;
import com.gogirl.shared.admin.techcnian.AchievementsPersonaResult;
import com.gogirl.shared.admin.techcnian.AchievementsPersonaResultPageApiRequest;
import com.gogirl.shared.admin.techcnian.AdminTechnicianScoreResp;
import com.gogirl.shared.admin.techcnian.GetTechnicianPageRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/8/17 9:09 上午
 */
@Api(tags = "4.0报表")
@RestController
@RequestMapping("/technician/dashboard")
public class DashboardController {
    @Resource
    AdminFeign adminFeign;
    @Resource
    DashboardService dashboardService;
    @Resource
    StoreManageService storeManageService;

    @ApiOperation("见doc文档getStoreTrendApi")
    @PostMapping("/no_getStoreTrendApi")
    public JsonResult<GetStoreTrendApiResp> getStoreTrendApi(@RequestBody GetStoreTrendApiRequest request,
                                                             @RequestHeader("brandId") Integer brandId) {

        request.setApi_brand_id(brandId);
        GetStoreTrendApiResp resp = dashboardService.getStoreTrendApi(request);
        return JsonResult.success(resp);
    }

    @ApiOperation("见doc文档getStoreListApi")
    @PostMapping("/no_getStoreListApi")
    public JsonResult<List<Map<String, Object>>> getStoreListApi(@RequestBody GetStoreListApiRequest request,
                                                                 @RequestHeader("brandId") Integer brandId) {
        request.setApi_brand_id(brandId);
        List<Map<String, Object>> result = dashboardService.getStoreListApi(request);
        return JsonResult.success(result);

    }

    @ApiOperation("见doc文档preStorageSumApi")
    @PostMapping("/no_preStorageSumApi")
    public JsonResult<Map<String, Object>> preStorageSumApi(@RequestBody PreStorageSumApiRequest request,
                                                            @RequestHeader("brandId") Integer brandId) {
        request.setApi_brand_id(brandId);
        Map<String, Object> result = dashboardService.preStorageSumApi(request);
        return JsonResult.success(result);

    }


    @ApiOperation("见doc文档revenueSumByTypeApi")
    @PostMapping(value = "/api/Report/no_revenueSumByTypeApi")
    public JsonResult<Map<String, Object>> revenueSumByTypeApi(@RequestBody RevenueSumByTypeApiRequest request,
                                                               @RequestHeader("brandId") Integer brandId) {
        request.setApi_brand_id(brandId);
        Map<String, Object> result = dashboardService.revenueSumByTypeApi(request);
        return JsonResult.success(result);
    }


    @ApiOperation("见doc文档revenueTypeListApi")
    @PostMapping("/no_revenueTypeListApi")
    public JsonResult<List<Map<String, Object>>> revenueTypeListApi(@RequestBody RevenueTypeListRequest request,
                                                                    @RequestHeader("brandId") Integer brandId) {
        request.setApi_brand_id(brandId);
        List<Map<String, Object>> result = dashboardService.revenueTypeListApi(request);
        return JsonResult.success(result);
    }


    @ApiOperation("见doc文档revenueSumApi")
    @PostMapping("/no_revenueSumApi")
    public JsonResult<List<Map<String, Object>>> revenueSumApi(@RequestBody RevenueSumApiRequest request,
                                                               @RequestHeader("brandId") Integer brandId) {
        request.setApi_brand_id(brandId);
        List<Map<String, Object>> result = dashboardService.revenueSumApi(request);
        return JsonResult.success(result);
    }


    @ApiOperation("美甲师信息")
    @PostMapping("/no_getTechnicianPage")
    public JsonResult<AdminPage<AdminTechnicianScoreResp>> getTechnicianPage(@RequestBody GetTechnicianPageRequest request,
                                                                             @RequestHeader("brandId") Integer brandId) {
        request.setApi_brand_id(brandId);
        AdminPage<AdminTechnicianScoreResp> respAdminPage = dashboardService.getTechnicianPage(request);
        return JsonResult.success(respAdminPage);
    }


    @ApiOperation("美甲师业绩")
    @PostMapping("/no_achievementsPersonaResultPageApi")
    public JsonResult<AdminPage<AchievementsPersonaResult>> achievementsPersonaResultPageApi(@RequestBody AchievementsPersonaResultPageApiRequest request,
                                                                                             @RequestHeader("brandId") Integer brandId) {
        request.setApi_brand_id(brandId);
        AdminPage<AchievementsPersonaResult> page = dashboardService.achievementsPersonaResultPageApi(request);
        return JsonResult.success(page);
    }


    @ApiOperation("1级/2级/3级 sku")
    @PostMapping("/no_revenueServiceListApi")
    public JsonResult<List<Map<String, Object>>> revenueServiceListApi(@RequestBody RevenueServiceListApiRequest request) {
        List<Map<String, Object>> result = dashboardService.revenueServiceListApi(request);
        return JsonResult.success(result);
    }
}
