package com.gogirl.infrastructure.common.filter;

import com.gogirl.infrastructure.common.exception.ErrorCode;
import com.gogirl.infrastructure.common.exception.RRException;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.stereotype.Component;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in  2021-05-05
 * @Modified by:
 */
@Component
@ServletComponentScan
@WebFilter(urlPatterns = {"/customer/*", "/technician/*"}, filterName = "requestbrandFilter")
public class RequestbrandFilter implements Filter {
    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String brandId = request.getHeader("brandId");
        if(StringUtils.isEmpty(brandId))
            throw new RRException(ErrorCode.ER_2008);
        filterChain.doFilter(servletRequest,servletResponse);
    }

    @Override
    public void destroy() {

    }
}
