package com.gogirl.domain.order.serve;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.user.customer.Customer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 如果要查询订单服务的评论标签 先根据order_serve.id查询List<OrderComment> orderCommentList
 * 然后 orderCommentList group by OrderComment#orderServeId 然后根据orderComment 的labelStick去查询
 */
@ApiModel("订单服务美甲师评论")
@Data
@TableName("order_comment")
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OrderComment implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("评论id")
    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("订单id")
    private Integer orderId;

    @ApiModelProperty("订单服务id")
    private Integer orderServeId;

    @ApiModelProperty("评论用户id")
    private Integer userId;

    @ApiModelProperty("等级")
    private Integer level;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("评论图片地址，逗号分隔")
    private String picturePath;

    @ApiModelProperty("便签贴")
    private String labelSticker;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("完成时间")
    private Date finishTime;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("状态 1-未评价 2-以评价")
    private Integer status;

    @ApiModelProperty("技师id  关联store_technician")
    private Integer technicianId;

    @ApiModelProperty("品牌ID")
    private Integer brandId;

    /**
     * 非数据库字段
     */
    @TableField(exist = false)
    @ApiModelProperty("店铺名")
    private String departmentName;

    @TableField(exist = false)
    private String orderNo;

    @TableField(exist = false)
    @ApiModelProperty("用户")
    private Customer customer;

    @TableField(exist = false)
    @ApiModelProperty("评论的美甲师")
    private StoreTechnician storeTechnician;

    @TableField(exist = false)
    @ApiModelProperty("订单评论关联的服务详情")
    private OrderServe orderServe;

    @TableField(exist = false)
    @ApiModelProperty("订单评论标签列表")
    private List<OrderCommentLabel> listOrderCommentLabel;

}
