package com.gogirl.domain.order.mall;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 运单号
 * </p>
 *
 * @author robbendev
 * @since 2020-10-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="MallOrderDelivery对象", description="运单号")
public class MallOrderDelivery implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    private Long orderId;

    @ApiModelProperty(value = "物流单号")
    private String no;

    @ApiModelProperty(value = "物流商")
    private String shipmentEnterprise;

    private Integer createUserId;

    private LocalDateTime createDate;

    @ApiModelProperty(value = "品牌id")
    private Integer brandId;


}
