package com.gogirl.application.store.store.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.common.xcx.GogirlTokenService;
import com.gogirl.application.common.xcx.WechatService;
import com.gogirl.application.store.store.StoreTechnicianService;
import com.gogirl.domain.common.xcx.GogirlToken;
import com.gogirl.domain.store.store.StoreManage;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.infrastructure.common.exception.ErrorCode;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.SessionUtils;
import com.gogirl.infrastructure.mapper.store.store.StoreManageMapper;
import com.gogirl.infrastructure.mapper.store.store.StoreTechnicianMapper;
import com.gogirl.infrastructure.mapper.store.store.UserTechnicianMapper;
import com.gogirl.shared.member.Code2SessionResult;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Slf4j
@Service
@AllArgsConstructor
@Transactional
public class StoreTechnicianServiceImpl extends ServiceImpl<StoreTechnicianMapper, StoreTechnician> implements StoreTechnicianService {

    private final UserTechnicianMapper StoreTechnicianMapper;
    private final WechatService wechatService;
    private final GogirlTokenService gogirlTokenService;
    private final StoreManageMapper storeManageMapper;


    @Override
    public List<StoreTechnician> listTechnicianForPage(StoreTechnician technicianManage) {
        return StoreTechnicianMapper.listTechnicianForPage(technicianManage);
    }


    @Override
    public String login(String code, Integer brandId) {
        Code2SessionResult responseResult = wechatService.getTechnicianOpenidByCode(code,brandId);

        if (responseResult.getErrcode() != null) {
            throw new RRException(responseResult.getErrmsg());
        }

        String openid = responseResult.getOpenid();

        //生成token
        String token = new BigInteger((int) (Math.random() * 1000) + new SimpleDateFormat("ddHHmmss").format(new Date()), 10).toString(16);
        StoreTechnician storeTechnician = this.getOne(new LambdaQueryWrapper<StoreTechnician>().eq(StoreTechnician::getOpenid, openid));

        if (storeTechnician == null) {
            throw new RRException(ErrorCode.TC_2006);
        }

        //美甲师token
        GogirlToken gogirlToken = new GogirlToken();
        gogirlToken.setSysId(2);
        gogirlToken.setOpenid(openid);
        // 返回美甲师信息及token
        gogirlToken.setCreateTime(new Date());
        gogirlToken.setUpdateTime(new Date());

        gogirlToken.setToken(token);
        gogirlToken.setTechnicianId(storeTechnician.getId());

        gogirlToken.setBrandId(storeTechnician.getBrandId());

        //只写入token不写入美甲师因为美甲师是后台创建的 后台创建是美甲师唯一来源
        gogirlTokenService.save(gogirlToken);
        return token;
    }


    @Override
    public void choseStore(Integer departmentId) {
        GogirlToken gogirlToken = SessionUtils.getTechnicianToken();
        if (gogirlToken == null) {
            throw new RRException(ErrorCode.CS_2000);
        }
        StoreManage storeManage = storeManageMapper.selectById(departmentId);

        gogirlToken.setDepartmentId(departmentId);
        gogirlToken.setDepartmentName(storeManage.getName());
        gogirlTokenService.updateByToken(gogirlToken);
    }

    @Override
    public StoreTechnician getTechnician() {
        Integer technicianId = SessionUtils.getTechnicianId();
        if (technicianId == null) {
            throw new RRException(ErrorCode.CS_2000);
        }
        StoreTechnician storeTechnician = this.getById(technicianId);
        GogirlToken gogirlToken = SessionUtils.getTechnicianToken();
        storeTechnician.setTechnicianId(storeTechnician.getId());
        storeTechnician.setDepartmentId(gogirlToken.getDepartmentId());
        storeTechnician.setDepartmentName(gogirlToken.getDepartmentName());
        return storeTechnician;
    }

    @Override
    public List<StoreTechnician> list(StoreTechnician storeTechnician) {
        LambdaQueryWrapper<StoreTechnician> wrapper = new LambdaQueryWrapper<>();
        if (storeTechnician.getDepartmentId() != null) {
            wrapper.eq(StoreTechnician::getDepartmentId, storeTechnician.getDepartmentId());
        }
        wrapper.eq(StoreTechnician::getIsAdmin, false);
        return this.list(wrapper);
    }
}
