package com.gogirl.application.product.serve;

import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.product.serve.TechniqueCategory;
import com.gogirl.domain.product.serve.TechniqueSku;

import javax.validation.constraints.Null;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 技法sku 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-05-27
 */
public interface ITechniqueSkuService extends IService<TechniqueSku> {

    /**
     * 查询所哟款式技法
     *
     * @return
     */
    List<TechniqueSku> queryAll(Integer brandId);

    /**
     * 查询所有款式技法分组 包括默认数量 单选多选
     *
     * @return
     */
    Map<String, List<TechniqueSku>> queryTechniqueSkuMap(Integer brandId);


    List<TechniqueCategory> queryTechniqueCategoryAggregate(@Null Integer scheduleServeId,
                                                            @Null Integer orderServeId,
                                                            @Null Integer serveId,
                                                            Integer brandId);
}
