package com.gogirl.shared.wx;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;
import java.util.TreeMap;

/**
 * @Author robbendev
 * @Description //TODO
 * @Date 2019/12/29
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class WxSubscribeMessageRequest<T> {

    /**
     * 接口调用凭证
     */
    private String accessToken;

    /**
     * 接收者（用户）的 openid
     */
    private String toUser;

    /**
     * 所需下发的订阅模板id
     */
    private String templateId;

    /**
     * 点击模板卡片后的跳转页面，仅限本小程序内的页面。支持带参数,（示例index?foo=bar）。该字段不填则模板无跳转。
     */
    private String page;

    /**
     * 模板内容，格式形如 { "key1": { "value": any }, "key2": { "value": any } }
     */
    private T data;

    public String toJson() {
        Map<String, Object> map = new TreeMap<>();
        map.put("access_token", accessToken);
        map.put("touser", toUser);
        map.put("template_id", templateId);
        map.put("page", page);
        map.put("data", data);
        return map.toString();
    }


}
