package com.gogirl.application.order.member;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.pagehelper.PageInfo;
import com.gogirl.domain.order.member.ChargeOrder;
import com.gogirl.domain.user.customer.CustomerBalanceRecord;

import java.net.UnknownHostException;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-03-08
 */
public interface IChargeOrderService extends IService<ChargeOrder> {

    /**
     * 充值订单回调
     *
     * @param result
     */
    void notifyChargeOrder(WxPayOrderNotifyResult result);

    /**
     * 用户充值会员卡
     * @param chargeId
     * @return
     */
    WxPayMpOrderResult customerChargeBalance(Integer chargeId) throws UnknownHostException, WxPayException;

    /**
     * 美甲师充值会员卡
     * @param name
     * @param phone
     * @param amount
     * @param source
     * @param refereeId
     * @param remark
     */
    void chargeCustomerCard(String name, String phone, Double amount, Integer source, String refereeId, String remark);


}
