package com.gogirl.assembler;

import com.gogirl.domain.order.serve.*;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.shared.order.serve.query.dto.ScheduleManageDTO;
import com.gogirl.shared.order.serve.query.dto.ordermanage.*;
import lombok.AllArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

import java.util.function.Function;
import java.util.stream.Collectors;

@Component
@AllArgsConstructor
public class OrderManageDTOAssembler implements Function<OrderManage, OrderManageDTO> {


    private final OrderServeDTOAssembler orderServeDTOAssembler;
    private final ScheduleManageDTOAssembler scheduleManageDTOAssembler;

    private final CouponCustomerRelevanceDTOAssembler couponCustomerRelevanceDTOAssembler;
    private final TimesCardCustomerRelevanceDTOAssembler timesCardCustomerRelevanceDTOAssembler;
    private final TimesCardUsedRecordDTOAssembler timesCardUsedRecordDTOAssembler;

    @Override
    public OrderManageDTO apply(OrderManage orderManage) {
        OrderManageDTO orderManageDTO = new OrderManageDTO();
        BeanUtils.copyProperties(orderManage, orderManageDTO);
        orderManageDTO.setOrderServeDTOList(
                orderManage.getListOrderServer()
                        .stream()
                        .map(orderServeDTOAssembler)
                        .collect(Collectors.toList())
        );
        if (orderManage.getScheduleManage() != null) {
            ScheduleManageDTO scheduleManageDTO = scheduleManageDTOAssembler.apply(orderManage.getScheduleManage());
            orderManageDTO.setScheduleManageDTO(scheduleManageDTO);
        }

        if (ListUtil.isNotEmpty(orderManage.getCouponCustomerRelevanceList())) {
            orderManageDTO.setCouponCustomerRelevanceDTOList(orderManage.getCouponCustomerRelevanceList()
                    .stream().map(couponCustomerRelevanceDTOAssembler).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty(orderManage.getListTimesCardRecord())) {
            orderManageDTO.setTimesCardUsedRecordDTOList(orderManage.getListTimesCardRecord()
                    .stream().map(timesCardUsedRecordDTOAssembler).collect(Collectors.toList()));
        }
        return orderManageDTO;
    }

    @Component
    @AllArgsConstructor
    static class OrderServeDTOAssembler implements Function<OrderServe, OrderServeDTO> {

        private final OrderServeSkuDTOAssembler orderServeSkuDTOAssembler;
        private final OrderRecordDTOAssembler orderRecordDTOAssembler;
        private final OrderServeDescribeDTOAssembler orderServeDescribeDTOAssembler;

        private final StoreTechnicianDTOAssembler storeTechnicianDTOAssembler;

        @Override
        public OrderServeDTO apply(OrderServe orderServe) {
            OrderServeDTO orderServeDTO = new OrderServeDTO();
            BeanUtils.copyProperties(orderServe, orderServeDTO);

            if (orderServe.getOrderRecord() != null) {
                orderServeDTO.setOrderRecordDTO(orderRecordDTOAssembler.apply(orderServe.getOrderRecord()));
            }

            if (ListUtil.isNotEmpty(orderServeDTO.getOrderServeDescribeDTOList())) {
                orderServeDTO.setOrderServeDescribeDTOList(orderServe
                        .getListOrderServeDescribe()
                        .stream().map(orderServeDescribeDTOAssembler)
                        .collect(Collectors.toList()));
            }

            if (ListUtil.isNotEmpty(orderServe.getListOrderServeSku())) {
                orderServeDTO.setOrderServeSkuDTOList(orderServe.getListOrderServeSku()
                        .stream()
                        .map(orderServeSkuDTOAssembler)
                        .collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty(orderServe.getListTechnicianManage())) {
                orderServeDTO.setStoreTechnicianDTOList(orderServe.getListTechnicianManage()
                        .stream()
                        .map(storeTechnicianDTOAssembler)
                        .collect(Collectors.toList()));
            }

            orderServeDTO.setTechnicianIds(orderServe.getTechnicianId());
            orderServeDTO.setTechnicianNames(orderServe.getTechnicianName());
            return orderServeDTO;
        }


        @Component
        static class OrderServeSkuDTOAssembler implements Function<OrderServeSku, OrderServeSkuDTO> {

            @Override
            public OrderServeSkuDTO apply(OrderServeSku orderServeSku) {
                OrderServeSkuDTO orderServeSkuDTO = new OrderServeSkuDTO();
                BeanUtils.copyProperties(orderServeSku, orderServeSkuDTO);
                return orderServeSkuDTO;
            }
        }

        @Component
        static class OrderRecordDTOAssembler implements Function<OrderRecord, OrderRecordDTO> {

            @Override
            public OrderRecordDTO apply(OrderRecord orderRecord) {
                OrderRecordDTO orderRecordDTO = new OrderRecordDTO();
                BeanUtils.copyProperties(orderRecord, orderRecordDTO);
                return orderRecordDTO;
            }
        }

        @Component
        static class OrderServeDescribeDTOAssembler implements Function<OrderServeDescribe, OrderServeDescribeDTO> {

            @Override
            public OrderServeDescribeDTO apply(OrderServeDescribe orderServeDescribe) {
                OrderServeDescribeDTO orderServeDescribeDTO = new OrderServeDescribeDTO();
                BeanUtils.copyProperties(orderServeDescribe, orderServeDescribeDTO);
                return orderServeDescribeDTO;
            }
        }


    }


}
