package com.gogirl.interfaces.store;


import com.gogirl.application.store.career.ITechScoreRulesService;
import com.gogirl.dto.TechScore;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-03-12
 */
@RestController
@AllArgsConstructor
public class TechScoreRulesController {

    private final ITechScoreRulesService techScoreRulesService;

    @ApiOperation("美甲师评分")
    @GetMapping("/technician/getTechScore")
    public JsonResult<TechScore> getTechScore() {
        TechScore techScore = techScoreRulesService.getTechScore();
        return JsonResult.success(techScore);
    }

}
