package com.gogirl.application.common.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.gogirl.application.common.IAgentUserService;
import com.gogirl.application.user.customer.CustomerService;
import com.gogirl.domain.common.AgentConfig;
import com.gogirl.domain.common.AgentUser;
import com.gogirl.domain.common.AgentUserBalanceLog;
import com.gogirl.domain.common.AgentUserLog;
import com.gogirl.domain.common.xcx.GogirlToken;
import com.gogirl.domain.user.customer.Customer;
import com.gogirl.infrastructure.common.config.property.GogirlProperties;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.SessionUtils;
import com.gogirl.infrastructure.mapper.common.AgentConfigMapper;
import com.gogirl.infrastructure.mapper.common.AgentUserBalanceLogMapper;
import com.gogirl.infrastructure.mapper.common.AgentUserLogMapper;
import com.gogirl.infrastructure.mapper.common.AgentUserMapper;
import com.gogirl.infrastructure.service.wx.WxPayService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * <p>
 * 代理用户 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-11-02
 */
@Service
public class AgentUserServiceImpl extends ServiceImpl<AgentUserMapper, AgentUser> implements IAgentUserService {

    @Resource
    AgentUserMapper agentUserMapper;
    @Resource
    AgentConfigMapper agentConfigMapper;
    @Resource
    GogirlProperties gogirlProperties;
    @Resource
    WxPayService wxPayService;

    @Override
    public AgentUser selectByPhone(String phone) {
        return this.getOne(new LambdaQueryWrapper<AgentUser>().eq(AgentUser::getPhone, phone));
    }

    @Override
    public WxPayMpOrderResult chargeAmount(Integer agentConfigId) throws UnknownHostException, WxPayException {
        GogirlToken gt = SessionUtils.getCustomerToken();

        AgentConfig agentConfig = agentConfigMapper.selectById(agentConfigId);

        SimpleDateFormat yyyyMMddHHmmss = new SimpleDateFormat("yyyyMMddHHmmss");
        WxPayUnifiedOrderRequest request = WxPayUnifiedOrderRequest.newBuilder()
                .deviceInfo("设备号")
                .body("充值" + agentConfig.getRechargeAmount().intValue())
                .detail("详情")
                .attach("c")
                .outTradeNo(IdWorker.getIdStr())
                //充值金额
                .totalFee(agentConfig.getRechargeAmount().add(agentConfig.getBondAmount()).multiply(new BigDecimal("100")).intValue())
                .spbillCreateIp(InetAddress.getLocalHost().getHostAddress())
                .timeStart(yyyyMMddHHmmss.format(new Date()))
                .notifyUrl(gogirlProperties.getNotifyChargeAgent())
                .tradeType("JSAPI")
                .openid(SessionUtils.getCustomerToken().getOpenid())
                .sceneInfo("gogirl美甲美睫沙龙")
                .build();

        return wxPayService.createJsapiOrder(request);
    }

    @Resource
    CustomerService customerService;
    @Resource
    AgentUserLogMapper agentUserLogMapper;

    @Override
    public void notifyChargeAgent(WxPayOrderNotifyResult result) {
        String openid = result.getOpenid();
        BigDecimal amount = new BigDecimal(result.getTotalFee()).divide(new BigDecimal(100), 2, RoundingMode.HALF_DOWN);
        Customer customer = customerService.selectByOpenid1(openid);

        AgentUser agentUser = this.selectByPhone(customer.getPhone());

        AgentConfig agentConfig = agentConfigMapper.selectByRechargeAmount(amount);


        //首次充值
        if (agentUser == null) {
            agentUser = new AgentUser();
            agentUser.setPhone(customer.getPhone());
            agentUser.setName(customer.getNickname());
            agentUser.setNo(IdWorker.getIdStr().substring(8));
            //todo
            agentUser.setLevel(agentConfig.getId());
            agentUser.setDiscount(agentConfig.getDiscount());
            agentUser.setCurrentStartTime(LocalDateTime.now());
            agentUser.setDueDate(LocalDateTime.now().plusYears(1));
            agentUser.setCreateUser(customer.getNickname());
            agentUser.setDueDate(LocalDateTime.now().plusYears(1));

            agentUserMapper.insert(agentUser);

            AgentUserLog agentUserLog = new AgentUserLog();
            agentUserLog.setAgentUserId(agentUser.getId());

            agentUserLogMapper.insert(agentUserLog);

        }

        this.addBalanceLog(3, agentConfig.getBondAmount(), agentUser.getId(), result.getOutTradeNo());
        this.addBalanceLog(1, amount.subtract(agentConfig.getBondAmount()), agentUser.getId(), result.getOutTradeNo());

    }

    @Resource
    AgentUserBalanceLogMapper agentUserBalanceLogMapper;

    @Override
    public void addBalanceLog(Integer type, BigDecimal amount, Integer agentUserId, String orderId) {
        AgentUser agentUser = agentUserMapper.selectById(agentUserId);
        Customer customer = customerService.selectByPhone(agentUser.getPhone());

        AgentUserBalanceLog agentUserBalanceLog;
        //1 = 充值余额 2 = 商城订单扣余额  3 = 充保证金 4 = 商城订单扣保证金
        switch (type) {
            //充值余额
            case 1:
                //余额
                agentUser.setBalance(agentUser.getBalance().add(amount));
                //预充金额
                agentUser.setRechargeAmount(amount);
                //累计充值
                agentUser.setCurrentRechargeAmount(agentUser.getCurrentRechargeAmount().add(amount));
                agentUserMapper.updateById(agentUser);

                agentUserBalanceLog = AgentUserBalanceLog.getInstance(agentUser);
                agentUserBalanceLog.setAmount(amount);
                agentUserBalanceLog.setCreateUser(customer.getNickname());
                agentUserBalanceLog.setType(type);
                agentUserBalanceLog.setOrderId(orderId);
                agentUserBalanceLogMapper.insert(agentUserBalanceLog);
                break;
            //商城订单扣余额
            case 2:
                //余额不足
                if (agentUser.getBalance().compareTo(amount) < 0) {
                    //能否抵扣保证金
                    if (agentUser.canUserBondAmount()) {
                        //余额不足
                        if (agentUser.getBondAmount().add(agentUser.getBalance()).compareTo(amount) < 0) {
                            throw new RRException("余额不足");
                        }
                        //商城订单扣余额
                        this.addBalanceLog(2, agentUser.getBalance(), agentUserId, orderId);
                        //商城订单扣保证金
                        this.addBalanceLog(4, amount.subtract(agentUser.getBalance()), agentUserId, orderId);
                    }
                } else {

                    //余额
                    agentUser.setBalance(agentUser.getBalance().subtract(amount));
                    //累计消费
                    agentUser.setCurrentConsumeAmount(agentUser.getCurrentConsumeAmount().add(amount));
                    agentUserMapper.updateById(agentUser);

                    //消费
                    agentUserBalanceLog = AgentUserBalanceLog.getInstance(agentUser);
                    agentUserBalanceLog.setAmount(BigDecimal.ZERO.subtract(amount));
                    agentUserBalanceLog.setCreateUser(customer.getNickname());
                    agentUserBalanceLog.setType(type);
                    agentUserBalanceLog.setOrderId(orderId);

                    agentUserBalanceLogMapper.insert(agentUserBalanceLog);
                }
                break;
            //充保证金
            case 3:
                //余额
                agentUser.setBondAmount(agentUser.getBondAmount().add(amount));
                //累计充值
                agentUser.setCurrentRechargeAmount(agentUser.getCurrentRechargeAmount().add(amount));
                agentUserMapper.updateById(agentUser);

                agentUserBalanceLog = AgentUserBalanceLog.getInstance(agentUser);
                agentUserBalanceLog.setAmount(amount);
                agentUserBalanceLog.setCreateUser(customer.getNickname());
                agentUserBalanceLog.setType(type);
                agentUserBalanceLog.setOrderId(orderId);

                agentUserBalanceLogMapper.insert(agentUserBalanceLog);
                break;
            //商城订单扣保证金
            case 4:

                //余额
                agentUser.setBondAmount(agentUser.getBondAmount().subtract(amount));
                //累计充值
                agentUser.setCurrentConsumeAmount(agentUser.getCurrentConsumeAmount().add(amount));
                agentUserMapper.updateById(agentUser);

                agentUserBalanceLog = AgentUserBalanceLog.getInstance(agentUser);
                agentUserBalanceLog.setAmount(amount);
                agentUserBalanceLog.setCreateUser(customer.getNickname());
                agentUserBalanceLog.setType(type);
                agentUserBalanceLog.setOrderId(orderId);

                agentUserBalanceLogMapper.insert(agentUserBalanceLog);
                break;
            default:
                throw new RRException("invalid type");
        }
        AgentConfig agentConfig = agentConfigMapper.selectByRechargeAmount(agentUser.getCurrentRechargeAmount());
        agentUser.setLevel(agentConfig.getId());
        agentUser.setDiscount(agentConfig.getDiscount());
        agentUserMapper.updateById(agentUser);

        //计算保证金
        if (!agentUser.canUserBondAmount()) {

        }
    }


    @Override
    public WxPayMpOrderResult chargeAmount(BigDecimal amount) throws UnknownHostException, WxPayException {


        SimpleDateFormat yyyyMMddHHmmss = new SimpleDateFormat("yyyyMMddHHmmss");
        WxPayUnifiedOrderRequest request = WxPayUnifiedOrderRequest.newBuilder()
                .deviceInfo("设备号")
                .body("充值" + amount)
                .detail("详情")
                .attach("c")
                .outTradeNo(IdWorker.getIdStr())
                //充值金额
                .totalFee(amount.multiply(new BigDecimal("100")).intValue())
                .spbillCreateIp(InetAddress.getLocalHost().getHostAddress())
                .timeStart(yyyyMMddHHmmss.format(new Date()))
                .notifyUrl(gogirlProperties.getNotifyChargeAgent())
                .tradeType("JSAPI")
                .openid(SessionUtils.getCustomerToken().getOpenid())
                .sceneInfo("gogirl美甲美睫沙龙")
                .build();

        return wxPayService.createJsapiOrder(request);
    }
}
